/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableBooleanExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
            String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression, new CommentTracker()));
            if (string == null) {
                SimplifiableBooleanExpressionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)info;
        String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression, new CommentTracker()));
        if (string == null) {
            SimplifiableBooleanExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableBooleanExpressionFix();
    }

    @NonNls
    static String calculateReplacementExpression(PsiPrefixExpression expression2, CommentTracker commentTracker) {
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (!(operand2 instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        return ParenthesesUtils.getText(commentTracker.markUnchanged(lhs), 9) + "==" + ParenthesesUtils.getText(commentTracker.markUnchanged(rhs), 9);
    }

    @NonNls
    static String calculateReplacementExpression(PsiBinaryExpression expression2, CommentTracker commentTracker) {
        String conjunctionRemnant;
        boolean isFirst;
        PsiPolyadicExpression conjunction = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand()), PsiPolyadicExpression.class);
        if (conjunction == null) {
            return null;
        }
        PsiExpression rightDisjunct = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
        if (rightDisjunct == null) {
            return null;
        }
        if (SimplifiableBooleanExpressionInspection.hasOperand(conjunction, rightDisjunct)) {
            return commentTracker.text((PsiElement)rightDisjunct);
        }
        PsiExpression[] operands2 = conjunction.getOperands();
        if (operands2.length < 2) {
            return null;
        }
        if (BoolUtils.areExpressionsOpposite(operands2[0], rightDisjunct)) {
            isFirst = true;
        } else if (BoolUtils.areExpressionsOpposite(operands2[operands2.length - 1], rightDisjunct)) {
            isFirst = false;
        } else {
            return null;
        }
        if (operands2.length == 2) {
            conjunctionRemnant = commentTracker.text(operands2[isFirst ? 1 : 0], 14);
        } else {
            conjunctionRemnant = isFirst ? commentTracker.rangeText((PsiElement)operands2[1], (PsiElement)operands2[operands2.length - 1]) : commentTracker.rangeText((PsiElement)operands2[0], (PsiElement)operands2[operands2.length - 2]);
            if (expression2.getLOperand() instanceof PsiParenthesizedExpression) {
                conjunctionRemnant = "(" + conjunctionRemnant + ")";
            }
        }
        return isFirst ? commentTracker.text(rightDisjunct, 14) + "||" + conjunctionRemnant : conjunctionRemnant + "||" + commentTracker.text(rightDisjunct, 14);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableBooleanExpressionVisitor();
    }

    private static boolean hasOperand(PsiPolyadicExpression polyadic, PsiExpression operand2) {
        if (operand2 == null) {
            return false;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        return Arrays.stream(polyadic.getOperands()).anyMatch(op -> equivalence.expressionsAreEquivalent((PsiExpression)op, operand2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection", "buildErrorString"));
    }

    private static class SimplifiableBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableBooleanExpressionVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!JavaTokenType.EXCL.equals(expression2.getOperationTokenType())) {
                return;
            }
            PsiBinaryExpression maybeXor = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand()), PsiBinaryExpression.class);
            if (maybeXor == null || !JavaTokenType.XOR.equals(maybeXor.getOperationTokenType())) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeXor.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeXor.getROperand());
            if (lhs == null || rhs == null) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitBinaryExpression(PsiBinaryExpression disjunction) {
            PsiExpression[] operands2;
            super.visitBinaryExpression(disjunction);
            if (!JavaTokenType.OROR.equals(disjunction.getOperationTokenType())) {
                return;
            }
            PsiPolyadicExpression conjunction = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)disjunction.getLOperand()), PsiPolyadicExpression.class);
            if (conjunction == null || !JavaTokenType.ANDAND.equals(conjunction.getOperationTokenType())) {
                return;
            }
            PsiExpression rightDisjunct = PsiUtil.skipParenthesizedExprDown((PsiExpression)disjunction.getROperand());
            if (SimplifiableBooleanExpressionInspection.hasOperand(conjunction, rightDisjunct) && !SideEffectChecker.mayHaveSideEffects((PsiExpression)conjunction)) {
                this.registerError((PsiElement)disjunction, disjunction);
            }
            if ((operands2 = conjunction.getOperands()).length >= 2 && (BoolUtils.areExpressionsOpposite(operands2[0], rightDisjunct) || BoolUtils.areExpressionsOpposite(operands2[operands2.length - 1], rightDisjunct)) && !SideEffectChecker.mayHaveSideEffects(rightDisjunct)) {
                this.registerError((PsiElement)disjunction, disjunction);
            }
        }
    }

    private static class SimplifiableBooleanExpressionFix
    extends InspectionGadgetsFix {
        private SimplifiableBooleanExpressionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableBooleanExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            String replacement;
            PsiElement element = descriptor.getPsiElement();
            CommentTracker commentTracker = new CommentTracker();
            if (element instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression, commentTracker);
            } else if (element instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
                replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(binaryExpression, commentTracker);
            } else {
                return;
            }
            if (replacement == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)element, replacement, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionFix", "getFamilyName"));
        }
    }
}

