/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.ConditionalModel;
import org.jetbrains.annotations.NotNull;

public class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement);
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection", "buildErrorString"));
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            PsiElement parent;
            super.visitConditionalExpression(expression2);
            ConditionalModel model = ConditionalModel.from(expression2);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null || generator.getTokenType().equals("?:")) {
                return;
            }
            PsiExpression replacement = generator.getReplacement();
            if (replacement != null && (parent = expression2.getParent()) instanceof PsiLambdaExpression && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)parent), () -> replacement)) {
                return;
            }
            this.registerError((PsiElement)expression2, generator.generate(new CommentTracker()));
        }
    }

    private static class SimplifiableConditionalFix
    extends InspectionGadgetsFix {
        private SimplifiableConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiConditionalExpression.class);
            if (expression2 == null) {
                return;
            }
            ConditionalModel model = ConditionalModel.from(expression2);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null || generator.getTokenType().equals("?:")) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String newExpression = generator.generate(tracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix", "getFamilyName"));
        }
    }
}

