/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementWithTooFewBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 2;
    public int m_limit = 2;

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        PsiSwitchBlock block = (PsiSwitchBlock)infos[1];
        if (block instanceof PsiSwitchExpression) {
            String string = branchCount == 0 ? InspectionGadgetsBundle.message("switch.expression.with.single.default.message", new Object[0]) : InspectionGadgetsBundle.message("switch.expression.with.too.few.branches.problem.descriptor", branchCount);
            if (string == null) {
                SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = branchCount == 0 ? InspectionGadgetsBundle.message("switch.statement.with.single.default.message", new Object[0]) : InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.problem.descriptor", branchCount);
        if (string == null) {
            SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        return (Boolean)infos[2] != false ? new UnwrapSwitchStatementFix(branchCount) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooFewBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection", "buildErrorString"));
    }

    public static class UnwrapSwitchStatementFix
    extends InspectionGadgetsFix {
        int myBranchCount;

        private UnwrapSwitchStatementFix(int branchCount) {
            this.myBranchCount = branchCount;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.myBranchCount == 0 ? this.getFamilyName() : CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"switch", "if"});
            if (string == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.unwrap", (Object[])new Object[]{"switch"});
            if (string == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiSwitchBlock block;
            if (project == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(3);
            }
            if ((block = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiSwitchBlock.class)) instanceof PsiSwitchStatement) {
                ConvertSwitchToIfIntention.doProcessIntention((PsiSwitchStatement)block);
            } else if (block instanceof PsiSwitchExpression) {
                UnwrapSwitchStatementFix.unwrapExpression((PsiSwitchExpression)block);
            }
        }

        public static void unwrapExpression(PsiSwitchExpression switchExpression) {
            PsiCodeBlock body2 = switchExpression.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 1 || !(statements[0] instanceof PsiSwitchLabeledRuleStatement)) {
                return;
            }
            PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statements[0];
            PsiStatement ruleBody = rule.getBody();
            if (!(ruleBody instanceof PsiExpressionStatement)) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)switchExpression, (PsiElement)((PsiExpressionStatement)ruleBody).getExpression());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$UnwrapSwitchStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$UnwrapSwitchStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SwitchStatementWithTooFewBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooFewBranchesVisitor() {
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            Object[] infos = this.processSwitch((PsiSwitchBlock)expression2);
            if (infos == null) {
                return;
            }
            this.registerError(expression2.getFirstChild(), infos);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            Object[] infos;
            if (statement == null) {
                SwitchStatementWithTooFewBranchesVisitor.$$$reportNull$$$0(0);
            }
            if ((infos = this.processSwitch((PsiSwitchBlock)statement)) == null) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, infos);
        }

        public Object @Nullable [] processSwitch(@NotNull PsiSwitchBlock block) {
            PsiSwitchLabeledRuleStatement statement;
            PsiStatement[] statements;
            PsiCodeBlock body2;
            if (block == null) {
                SwitchStatementWithTooFewBranchesVisitor.$$$reportNull$$$0(1);
            }
            if ((body2 = block.getBody()) == null) {
                return null;
            }
            int branches = 0;
            boolean defaultFound = false;
            for (PsiSwitchLabelStatementBase child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatementBase.class)) {
                if (child.isDefaultCase()) {
                    defaultFound = true;
                    continue;
                }
                PsiExpressionList values = child.getCaseValues();
                if (values == null) {
                    return null;
                }
                if ((branches += values.getExpressionCount()) < SwitchStatementWithTooFewBranchesInspection.this.m_limit) continue;
                return null;
            }
            if (branches == 0 && !defaultFound) {
                return null;
            }
            boolean fixIsAvailable = block instanceof PsiSwitchStatement ? ConvertSwitchToIfIntention.isAvailable((PsiSwitchStatement)block) : ((statements = body2.getStatements()).length == 1 && statements[0] instanceof PsiSwitchLabeledRuleStatement ? (statement = (PsiSwitchLabeledRuleStatement)statements[0]).isDefaultCase() && statement.getBody() instanceof PsiExpressionStatement : false);
            return new Object[]{branches, block, fixIsAvailable};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$SwitchStatementWithTooFewBranchesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processSwitch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

