/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryContinueInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryContinueInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInThenBranch");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryContinueVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("continue");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection", "buildErrorString"));
    }

    private class UnnecessaryContinueVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryContinueVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                UnnecessaryContinueVisitor.$$$reportNull$$$0(0);
            }
            PsiStatement continuedStatement = statement.findContinuedStatement();
            PsiStatement body2 = null;
            if (continuedStatement instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)continuedStatement;
                body2 = foreachStatement.getBody();
            } else if (continuedStatement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)continuedStatement;
                body2 = forStatement.getBody();
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)continuedStatement;
                body2 = doWhileStatement.getBody();
            } else if (continuedStatement instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)continuedStatement;
                body2 = whileStatement.getBody();
            }
            if (body2 == null) {
                return;
            }
            if (UnnecessaryContinueInspection.this.ignoreInThenBranch && UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement)) {
                return;
            }
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)statement)) {
                    this.registerStatementError((PsiStatement)statement, new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement(body2, (PsiStatement)statement)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection$UnnecessaryContinueVisitor", "visitContinueStatement"));
        }
    }
}

