/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ReuseOfLocalVariableInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReuseOfLocalVariableFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReuseOfLocalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection", "buildErrorString"));
    }

    private static class ReuseOfLocalVariableVisitor
    extends BaseInspectionVisitor {
        private ReuseOfLocalVariableVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            PsiElement assignmentParent = assignment.getParent();
            if (!(assignmentParent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiLocalVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)referent;
            if (variable.getInitializer() == null) {
                return;
            }
            IElementType tokenType = assignment.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                return;
            }
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (variableBlock == null) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.hasParentOfTypeBeforeAncestor((PsiElement)assignment, (PsiElement)variableBlock, PsiLoopStatement.class, PsiTryStatement.class)) {
                return;
            }
            PsiElement assignmentBlock = assignmentParent.getParent();
            if (assignmentBlock == null) {
                return;
            }
            if (variableBlock.equals(assignmentBlock)) {
                this.registerError((PsiElement)lhs, new Object[0]);
                return;
            }
            if (assignmentBlock instanceof PsiCodeBlock) {
                PsiCodeBlock block = (PsiCodeBlock)assignmentBlock;
                boolean before = true;
                for (PsiStatement statement : block.getStatements()) {
                    if (statement.equals(assignmentParent)) {
                        before = false;
                    }
                    if (before) continue;
                    if (statement instanceof PsiBreakStatement) break;
                    if (!(statement instanceof PsiReturnStatement) && !(statement instanceof PsiThrowStatement)) continue;
                    this.registerError((PsiElement)lhs, new Object[0]);
                    return;
                }
            }
            PsiElement child = assignmentBlock;
            PsiElement parent = child.getParent();
            block1: while (parent != null) {
                boolean before = true;
                if (child instanceof PsiSwitchLabeledRuleStatement) {
                    PsiSwitchLabeledRuleStatement ruleStatement = (PsiSwitchLabeledRuleStatement)child;
                    parent = ruleStatement.getEnclosingSwitchBlock();
                } else if (child instanceof PsiBreakStatement) {
                    PsiBreakStatement breakStatement = (PsiBreakStatement)child;
                    parent = breakStatement.findExitedStatement();
                } else if (parent instanceof PsiCodeBlock) {
                    for (PsiStatement statement : ((PsiCodeBlock)parent).getStatements()) {
                        if (statement.equals(child)) {
                            before = false;
                            continue;
                        }
                        if (before) continue;
                        if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)statement)) {
                            return;
                        }
                        if (statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) break block1;
                    }
                }
                if (parent == variableBlock || parent == null) break;
                child = parent;
                parent = child.getParent();
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        private static <T extends PsiElement> boolean hasParentOfTypeBeforeAncestor(@NotNull PsiElement descendant, @NotNull PsiElement ancestor, Class<? extends T> ... classes2) {
            if (descendant == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if (ancestor == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(2);
            }
            if (classes2 == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(3);
            }
            for (PsiElement elementToTest = descendant.getParent(); elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(ancestor)) {
                    return false;
                }
                if (!PsiTreeUtil.instanceOf((Object)elementToTest, (Class[])classes2)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descendant";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasParentOfTypeBeforeAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReuseOfLocalVariableFix
    extends InspectionGadgetsFix {
        private ReuseOfLocalVariableFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("reuse.of.local.variable.split.quickfix", new Object[0]);
            if (string == null) {
                ReuseOfLocalVariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiLocalVariable variable = (PsiLocalVariable)referenceExpression.resolve();
            if (variable == null) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiUtil.skipParenthesizedExprUp((PsiElement)referenceExpression.getParent());
            if (assignment == null) {
                return;
            }
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)assignment.getParent();
            PsiExpression lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
            if (lExpression == null) {
                return;
            }
            String originalVariableName = lExpression.getText();
            PsiType type2 = variable.getType();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            String newVariableName = codeStyleManager.suggestUniqueVariableName(originalVariableName, (PsiElement)variableBlock, false);
            LocalSearchScope scope = new LocalSearchScope(assignmentStatement.getParent());
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)false);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            ArrayList<PsiReferenceExpression> collectedReferences = new ArrayList<PsiReferenceExpression>();
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                TextRange textRange = assignmentStatement.getTextRange();
                if (referenceElement.getTextOffset() <= textRange.getEndOffset()) continue;
                PsiExpression newExpression = factory.createExpressionFromText(newVariableName, referenceElement);
                PsiReferenceExpression replacementExpression = (PsiReferenceExpression)referenceElement.replace((PsiElement)newExpression);
                collectedReferences.add(replacementExpression);
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression rhs = assignment.getRExpression();
            String rhsText = rhs == null ? "" : commentTracker.text((PsiElement)rhs);
            String newStatementText = type2.getCanonicalText() + ' ' + newVariableName + " =  " + rhsText + ';';
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)BlockUtils.addAfter((PsiStatement)assignmentStatement, factory.createStatementFromText(newStatementText, (PsiElement)assignmentStatement));
            assignmentStatement = (PsiExpressionStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)declarationStatement, PsiExpressionStatement.class);
            commentTracker.deleteAndRestoreComments((PsiElement)Objects.requireNonNull(assignmentStatement));
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            PsiLocalVariable newVariable = (PsiLocalVariable)elements[0];
            PsiElement context = declarationStatement.getParent();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)newVariable, (PsiReference[])collectedReferences.toArray(new PsiReferenceExpression[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableFix", "getFamilyName"));
        }
    }
}

