/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public class CyclicClassDependencyInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        RefClass[] classes2;
        if (refEntity == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        if (refClass.isAnonymous() || refClass.isLocalClass() || refClass.isSyntheticJSP()) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateTransitiveDependenciesForClass(refClass);
        Set<RefClass> dependents = DependencyUtils.calculateTransitiveDependentsForClass(refClass);
        HashSet<RefClass> mutualDependents = new HashSet<RefClass>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        if (numMutualDependents == 1) {
            classes2 = mutualDependents.toArray(new RefClass[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.1.problem.descriptor", refEntity.getName(), classes2[0].getExternalName());
        } else if (numMutualDependents == 2) {
            classes2 = mutualDependents.toArray(new RefClass[2]);
            Arrays.sort(classes2, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.2.problem.descriptor", refEntity.getName(), classes2[0].getExternalName(), classes2[1].getExternalName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.problem.descriptor", refEntity.getName(), numMutualDependents);
        }
        PsiElement anchor = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (anchor == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(anchor, errorString, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/dependency/CyclicClassDependencyInspection";
        objectArray[2] = "checkElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

