/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NewExceptionWithoutArgumentsInspection
extends BaseInspection {
    @Deprecated
    public boolean ignoreWithoutParameters;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NewExceptionWithoutArgumentsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/NewExceptionWithoutArgumentsInspection", "buildErrorString"));
    }

    private static class NewExceptionWithoutArgumentsVisitor
    extends BaseInspectionVisitor {
        private NewExceptionWithoutArgumentsVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
            if (classReference2 == null) {
                return;
            }
            PsiElement target = classReference2.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            if (NewExceptionWithoutArgumentsVisitor.hasAccessibleConstructorWithParameters(aClass, (PsiElement)expression2)) {
                this.registerNewExpressionError(expression2, new Object[0]);
            }
        }

        private static boolean hasAccessibleConstructorWithParameters(PsiClass aClass, PsiElement context) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiResolveHelper resolveHelper;
                PsiParameterList parameterList = constructor.getParameterList();
                int count = parameterList.getParametersCount();
                if (count <= 0 || !(resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper()).isAccessible((PsiMember)constructor, context, aClass)) continue;
                return true;
            }
            return false;
        }
    }
}

