/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ReplaceInheritanceWithDelegationFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ExtendsConcreteCollectionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[1];
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        return new ReplaceInheritanceWithDelegationFix();
    }

    @NotNull
    public String getID() {
        return "ClassExtendsConcreteCollection";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass aClass = (PsiClass)infos[1];
        if (aClass instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("anonymous.extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
            if (string == null) {
                ExtendsConcreteCollectionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
        if (string == null) {
            ExtendsConcreteCollectionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsConcreteCollectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection", "buildErrorString"));
    }

    private static class ExtendsConcreteCollectionVisitor
    extends BaseInspectionVisitor {
        private ExtendsConcreteCollectionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExtendsConcreteCollectionVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (!CollectionUtils.isConcreteCollectionClass(superClass)) {
                return;
            }
            String qualifiedName = superClass.getQualifiedName();
            if ("java.util.LinkedHashMap".equals(qualifiedName)) {
                PsiMethod[] methods = aClass.findMethodsByName("removeEldestEntry", false);
                PsiClassType entryType = TypeUtils.getType("java.util.Map.Entry", (PsiElement)aClass);
                for (PsiMethod method : methods) {
                    PsiParameter parameter2;
                    PsiParameterList parameterList;
                    if (!PsiType.BOOLEAN.equals((Object)method.getReturnType()) || (parameterList = method.getParameterList()).getParametersCount() != 1 || !entryType.isAssignableFrom((parameter2 = parameterList.getParameters()[0]).getType())) continue;
                    return;
                }
            }
            this.registerClassError(aClass, superClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspection$ExtendsConcreteCollectionVisitor", "visitClass"));
        }
    }
}

