/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class InterfaceNeverImplementedInspection
extends BaseInspection {
    public boolean ignoreInterfacesThatOnlyDeclareConstants = false;
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            InterfaceNeverImplementedInspection.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "ignorableAnnotations");
        this.ignorableAnnotations.writeSettings(node, "ignorableAnnotations");
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)aClass, (List<String>)((Object)this.ignorableAnnotations));
        if (inspectionGadgetsFixArray == null) {
            InterfaceNeverImplementedInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel annotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("interface.never.implemented.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInterfacesThatOnlyDeclareConstants");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel2.add((Component)annotationsPanel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel2.add((Component)checkBox, constraints);
        return panel2;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.never.implemented.problem.descriptor", new Object[0]);
        if (string == null) {
            InterfaceNeverImplementedInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceNeverImplementedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InterfaceNeverImplementedVisitor
    extends BaseInspectionVisitor {
        private InterfaceNeverImplementedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                InterfaceNeverImplementedVisitor.$$$reportNull$$$0(0);
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (InterfaceNeverImplementedInspection.this.ignoreInterfacesThatOnlyDeclareConstants && aClass.getMethods().length == 0 && aClass.getFields().length != 0) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)InterfaceNeverImplementedInspection.this.ignorableAnnotations), (int)0) || InheritanceUtil.hasImplementation(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/InterfaceNeverImplementedInspection$InterfaceNeverImplementedVisitor", "visitClass"));
        }
    }
}

