/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ReplaceAssertEqualsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsCalledOnArrayInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assertequals.called.on.arrays.problem.descriptor", new Object[0]);
        if (string == null) {
            AssertEqualsCalledOnArrayInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssertEqualsFix("assertArrayEquals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsOnArrayVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsCalledOnArrayInspection", "buildErrorString"));
    }

    private static class AssertEqualsOnArrayVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsOnArrayVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2);
            if (assertHint == null) {
                return;
            }
            PsiClass containingClass = Objects.requireNonNull(Objects.requireNonNull(expression2.resolveMethod()).getContainingClass());
            if (!Objects.requireNonNull(containingClass.getQualifiedName()).contains("junit")) {
                return;
            }
            PsiType type1 = assertHint.getFirstArgument().getType();
            PsiType type2 = assertHint.getSecondArgument().getType();
            if (!(type1 instanceof PsiArrayType) || !(type2 instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

