/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.JavaLoggingUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithMultipleLoggersInspection
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = StringUtil.join(JavaLoggingUtils.DEFAULT_LOGGERS, (String)",");

    public ClassWithMultipleLoggersInspection() {
        ClassWithMultipleLoggersInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.loggerNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.loggers.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithMultipleLoggersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ClassWithMultipleLoggersInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        ClassWithMultipleLoggersInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ClassWithMultipleLoggersInspection.$$$reportNull$$$0(2);
        }
        this.loggerNamesString = ClassWithMultipleLoggersInspection.formatString(this.loggerNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithMultipleLoggersVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/ClassWithMultipleLoggersInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/ClassWithMultipleLoggersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ClassWithMultipleLoggersVisitor
    extends BaseInspectionVisitor {
        private ClassWithMultipleLoggersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassWithMultipleLoggersVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            int numLoggers = 0;
            for (PsiField field : aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field)) continue;
                ++numLoggers;
            }
            if (numLoggers <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return ClassWithMultipleLoggersInspection.this.loggerNames.contains(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspection$ClassWithMultipleLoggersVisitor", "visitClass"));
        }
    }
}

