/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InnerClassMayBeStaticInspection
extends BaseInspection {
    public OrderedSet<String> ignorableAnnotations = new OrderedSet(Collections.singletonList("org.junit.jupiter.api.Nested"));

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            InnerClassMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.ignorableAnnotations, InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        fixes.add(new InnerClassMayBeStaticFix());
        PsiClass aClass = (PsiClass)infos[0];
        AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)aClass, this.ignorableAnnotations, fixes);
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            InnerClassMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassMayBeStaticVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/InnerClassMayBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private InnerClassMayBeStaticVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                InnerClassMayBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
                return;
            }
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
                return;
            }
            for (PsiClass innerClass : aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("static") || AnnotationUtil.isAnnotated((PsiModifierListOwner)innerClass, InnerClassMayBeStaticInspection.this.ignorableAnnotations, (int)0)) continue;
                InnerClassReferenceVisitor visitor2 = new InnerClassReferenceVisitor(innerClass);
                innerClass.accept((PsiElementVisitor)visitor2);
                if (!visitor2.canInnerClassBeStatic()) continue;
                this.registerClassError(innerClass, innerClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticVisitor", "visitClass"));
        }
    }

    private static class InnerClassMayBeStaticFix
    extends InspectionGadgetsFix {
        private InnerClassMayBeStaticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.static.quickfix", new Object[0]);
            if (string == null) {
                InnerClassMayBeStaticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaToken classNameToken = (PsiJavaToken)descriptor.getPsiElement();
            PsiClass innerClass = (PsiClass)classNameToken.getParent();
            if (innerClass == null) {
                return;
            }
            SearchScope useScope = innerClass.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)innerClass, (SearchScope)useScope);
            Collection references = query.findAll();
            ArrayList<Object> elements = new ArrayList<Object>(references.size() + 1);
            for (PsiReference reference : references) {
                elements.add(reference.getElement());
            }
            elements.add(innerClass);
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            WriteAction.run(() -> InnerClassMayBeStaticFix.makeStatic(innerClass, references));
        }

        private static void makeStatic(PsiClass innerClass, Collection<? extends PsiReference> references) {
            Project project = innerClass.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            references.stream().sorted((r1, r2) -> PsiUtilCore.compareElementsByPosition((PsiElement)r2.getElement(), (PsiElement)r1.getElement())).forEach(reference -> {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiNewExpression)) {
                    return;
                }
                PsiNewExpression newExpression = (PsiNewExpression)parent;
                PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
                if (classReference2 == null) {
                    return;
                }
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiReferenceParameterList parameterList = classReference2.getParameterList();
                String genericParameters = parameterList != null ? parameterList.getText() : "";
                PsiExpression expression2 = factory.createExpressionFromText("new " + classReference2.getQualifiedName() + genericParameters + argumentList.getText(), (PsiElement)innerClass);
                codeStyleManager.shortenClassReferences(newExpression.replace((PsiElement)expression2));
            });
            PsiModifierList modifiers = innerClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("static", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/InnerClassMayBeStaticInspection$InnerClassMayBeStaticFix", "getFamilyName"));
        }
    }
}

