/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ClassNamePrefixedWithPackageNameInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.prefixed.with.package.name.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassNamePrefixedWithPackageNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameBePrefixedWithPackageNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspection", "buildErrorString"));
    }

    private static class ClassNameBePrefixedWithPackageNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameBePrefixedWithPackageNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String lowercasePackageName;
            String className2;
            if (aClass == null) {
                ClassNameBePrefixedWithPackageNameVisitor.$$$reportNull$$$0(0);
            }
            if ((className2 = aClass.getName()) == null) {
                return;
            }
            PsiClass outerClass = ClassUtils.getOutermostContainingClass(aClass);
            String qualifiedName = outerClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            if (className2.equals(qualifiedName)) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
            String currentPackageName = null;
            String lastPackageName = null;
            while (tokenizer.hasMoreTokens()) {
                lastPackageName = currentPackageName;
                currentPackageName = tokenizer.nextToken();
            }
            if (lastPackageName == null) {
                return;
            }
            String lowercaseClassName = StringUtil.toLowerCase((String)className2);
            if (!lowercaseClassName.startsWith(lowercasePackageName = StringUtil.toLowerCase((String)lastPackageName))) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspection$ClassNameBePrefixedWithPackageNameVisitor", "visitClass"));
        }
    }
}

