/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingMainMethodInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.main.method.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingMainMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingMainMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ConfusingMainMethodInspection", "buildErrorString"));
    }

    private static class ConfusingMainMethodVisitor
    extends BaseInspectionVisitor {
        private ConfusingMainMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod aMethod) {
            String methodName;
            if (aMethod == null) {
                ConfusingMainMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!"main".equals(methodName = aMethod.getName())) {
                return;
            }
            if (!aMethod.hasModifierProperty("public")) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            if (!aMethod.hasModifierProperty("static")) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiType returnType = aMethod.getReturnType();
            if (!TypeUtils.typeEquals("void", returnType)) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiParameterList parameterList = aMethod.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiType parameterType = parameters2[0].getType();
            if (!TypeUtils.typeEquals("java.lang.String[]", parameterType)) {
                this.registerMethodError(aMethod, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aMethod", "com/siyeh/ig/naming/ConfusingMainMethodInspection$ConfusingMainMethodVisitor", "visitMethod"));
        }
    }
}

