/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldNamingConventionInspection
extends AbstractNamingConventionInspection<PsiField> {
    public static final ExtensionPointName<NamingConvention<PsiField>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.field");

    public FieldNamingConventionInspection() {
        super((Iterable)EP_NAME.getExtensionList(), null);
        this.registerConventionsListener(EP_NAME);
    }

    @Nullable
    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitField(PsiField field) {
                String name2 = field.getName();
                FieldNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)field, name2, holder);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/naming/FieldNamingConventionInspection", "buildVisitor"));
    }

    static class FieldNamingConventionBean
    extends NamingConventionBean {
        FieldNamingConventionBean(String regex, int minLength, int maxLength) {
            super(regex, minLength, maxLength, new String[]{"serialVersionUID"});
        }
    }
}

