/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.NotNull;

abstract class CastedLiteralMaybeJustLiteralInspection
extends BaseInspection {
    CastedLiteralMaybeJustLiteralInspection() {
    }

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = this.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.problem.descriptor", replacementText);
        if (string == null) {
            CastedLiteralMaybeJustLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    abstract String getSuffix();

    @NotNull
    abstract PsiType getTypeBeforeCast();

    @NotNull
    abstract PsiPrimitiveType getCastType();

    private StringBuilder buildReplacementText(PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiLiteralExpression) {
            out.append(expression2.getText()).append(this.getSuffix());
        } else {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                out.append(prefixExpression.getOperationSign().getText());
                return this.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                out.append('(');
                this.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                this.buildReplacementText(typeCastExpression.getOperand(), out);
            } else assert (false);
        }
        return out;
    }

    @Override
    protected final InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = this.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return new ReplaceCastedLiteralWithJustLiteralFix(replacementText.toString());
    }

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new CastedLiteralMayBeJustLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection", "buildErrorString"));
    }

    private class CastedLiteralMayBeJustLiteralVisitor
    extends BaseInspectionVisitor {
        private CastedLiteralMayBeJustLiteralVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!CastedLiteralMaybeJustLiteralInspection.this.getTypeBeforeCast().equals(type2)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiPrefixExpression || parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (!CastedLiteralMaybeJustLiteralInspection.this.getCastType().equals((Object)castType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)typeCastExpression, false);
            if (expectedType == null) {
                return;
            }
            if (!CastedLiteralMaybeJustLiteralInspection.this.getCastType().equals((Object)expectedType)) {
                PsiClassType boxedType = CastedLiteralMaybeJustLiteralInspection.this.getCastType().getBoxedType((PsiElement)expression2);
                assert (boxedType != null);
                if (!boxedType.equals((Object)expectedType)) {
                    return;
                }
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }
    }

    private class ReplaceCastedLiteralWithJustLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        ReplaceCastedLiteralWithJustLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementString});
            if (string == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.casted.literal.with.just.literal.fix.family.name", CastedLiteralMaybeJustLiteralInspection.this.getCastType().getPresentableText());
            if (string == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection$ReplaceCastedLiteralWithJustLiteralFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

