/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class InstantiatingObjectToGetClassObjectInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.problem.descriptor", new Object[0]);
        if (string == null) {
            InstantiatingObjectToGetClassObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        if (ExpressionUtils.isVoidContext((PsiExpression)methodCallExpression)) {
            return null;
        }
        return new InstantiatingObjectToGetClassObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstantiatingObjectToGetClassObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection", "buildErrorString"));
    }

    private static class InstantiatingObjectToGetClassObjectVisitor
    extends BaseInspectionVisitor {
        private InstantiatingObjectToGetClassObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                InstantiatingObjectToGetClassObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getClass".equals(methodName) || !expression2.getArgumentList().isEmpty()) {
                return;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            if (newExpression.getAnonymousClass() != null) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectVisitor", "visitMethodCallExpression"));
        }
    }

    private static class InstantiatingObjectToGetClassObjectFix
    extends InspectionGadgetsFix {
        private InstantiatingObjectToGetClassObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.replace.quickfix", new Object[0]);
            if (string == null) {
                InstantiatingObjectToGetClassObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, InstantiatingObjectToGetClassObjectFix.getTypeText(type2, new StringBuilder()) + ".class", new CommentTracker());
        }

        private static StringBuilder getTypeText(PsiType type2, StringBuilder text2) {
            if (type2 instanceof PsiArrayType) {
                text2.append("[]");
                PsiArrayType arrayType = (PsiArrayType)type2;
                InstantiatingObjectToGetClassObjectFix.getTypeText(arrayType.getComponentType(), text2);
            } else if (type2 instanceof PsiClassType) {
                PsiClass aClass = ((PsiClassType)type2).resolve();
                if (aClass != null && PsiUtil.isLocalClass((PsiClass)aClass)) {
                    text2.insert(0, aClass.getName());
                    for (aClass = aClass.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                        text2.insert(0, aClass.getName() + '.');
                    }
                } else {
                    String canonicalText = type2.getCanonicalText();
                    String typeText = PsiNameHelper.getQualifiedClassName((String)canonicalText, (boolean)false);
                    text2.insert(0, typeText);
                }
            } else {
                text2.insert(0, type2.getCanonicalText());
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectFix", "getFamilyName"));
        }
    }
}

