/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

class MethodReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean m_referencesStaticallyAccessible = true;
    private final PsiMember m_method;

    MethodReferenceVisitor(PsiMember method) {
        this.m_method = method;
    }

    public boolean areReferencesStaticallyAccessible() {
        return this.m_referencesStaticallyAccessible;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(0);
        }
        if (!this.m_referencesStaticallyAccessible) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        PsiElement resolvedElement = reference.resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)resolvedElement;
        PsiElement scope = aClass.getScope();
        if (!(scope instanceof PsiClass)) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        this.m_referencesStaticallyAccessible = false;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        PsiMember member;
        if (expression2 == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(1);
        }
        super.visitReferenceExpression(expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return;
        }
        PsiElement element = expression2.resolve();
        if (element instanceof PsiMember ? this.isMemberStaticallyAccessible(member = (PsiMember)element) : element != null) {
            return;
        }
        this.m_referencesStaticallyAccessible = false;
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression2) {
        if (expression2 == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(2);
        }
        super.visitThisExpression(expression2);
        this.m_referencesStaticallyAccessible = false;
    }

    private boolean isMemberStaticallyAccessible(PsiMember member) {
        PsiClass containingClass;
        if (this.m_method.equals(member)) {
            return true;
        }
        if (member.hasModifierProperty("static")) {
            return true;
        }
        PsiClass referenceContainingClass = this.m_method.getContainingClass();
        return !InheritanceUtil.isInheritorOrSelf((PsiClass)referenceContainingClass, (PsiClass)(containingClass = member.getContainingClass()), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/performance/MethodReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

