/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringEqualsEmptyStringInspection
extends BaseInspection {
    public boolean SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.equals.empty.string.option.do.not.add.null.check", new Object[0]), (InspectionProfileEntry)this, "SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        if (useIsEmpty) {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.is.empty.problem.descriptor", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
        if (string == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        boolean addNullCheck = (Boolean)infos[1];
        StringEqualsEmptyStringFix mainFix = new StringEqualsEmptyStringFix(useIsEmpty, addNullCheck);
        if (addNullCheck) {
            SetInspectionOptionFix disableFix = new SetInspectionOptionFix((LocalInspectionTool)this, "SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL", InspectionGadgetsBundle.message("string.equals.empty.string.option.do.not.add.null.check", new Object[0]), true);
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{mainFix, new DelegatingFix(disableFix)};
            if (inspectionGadgetsFixArray == null) {
                StringEqualsEmptyStringInspection.$$$reportNull$$$0(2);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{mainFix};
        if (inspectionGadgetsFixArray == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    private static PsiExpression getCheckedExpression(boolean useIsEmpty, PsiExpression expression2) {
        if (useIsEmpty || !(expression2 instanceof PsiMethodCallExpression)) {
            return expression2;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (qualifierExpression2 == null) {
            return expression2;
        }
        PsiType type2 = qualifierExpression2.getType();
        if ("toString".equals(referenceName) && type2 != null && (type2.equalsToText("java.lang.StringBuffer") || type2.equalsToText("java.lang.StringBuilder"))) {
            return qualifierExpression2;
        }
        return expression2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                StringEqualsEmptyStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement context = call.getParent();
            boolean useIsEmpty = PsiUtil.isLanguageLevel6OrHigher((PsiElement)call);
            if (!useIsEmpty && context instanceof PsiExpressionStatement) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            boolean addNullCheck = false;
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(qualifier)) {
                PsiType type2 = argument.getType();
                if (!TypeUtils.isJavaLangString(type2)) {
                    return;
                }
                PsiExpression expression2 = StringEqualsEmptyStringInspection.getCheckedExpression(useIsEmpty, argument);
                boolean bl = addNullCheck = expression2 == argument && NullabilityUtil.getExpressionNullability(expression2, true) != Nullability.NOT_NULL;
                if (addNullCheck && !ExpressionUtils.isSafelyRecomputableExpression(expression2)) {
                    return;
                }
            } else if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                if (qualifier == null) {
                    return;
                }
                PsiType type3 = qualifier.getType();
                if (!TypeUtils.isJavaLangString(type3)) {
                    return;
                }
            } else {
                return;
            }
            if (addNullCheck && StringEqualsEmptyStringInspection.this.SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL) {
                return;
            }
            this.registerMethodCallError(call, useIsEmpty, addNullCheck);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringVisitor", "visitMethodCallExpression"));
        }
    }

    private static class StringEqualsEmptyStringFix
    extends InspectionGadgetsFix {
        private final boolean myUseIsEmpty;
        private final boolean myAddNullCheck;

        StringEqualsEmptyStringFix(boolean useIsEmpty, boolean addNullCheck) {
            this.myUseIsEmpty = useIsEmpty;
            this.myAddNullCheck = addNullCheck;
        }

        @NotNull
        public String getName() {
            if (this.myUseIsEmpty) {
                String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isEmpty()"});
                if (string == null) {
                    StringEqualsEmptyStringFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"length()==0"});
            if (string == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.fix.family.name", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression expressionToReplace;
            StringBuilder newExpression;
            PsiReferenceExpression expression2 = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiReferenceExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2.getParent();
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiExpression checkedExpression = ExpressionUtils.isEmptyStringLiteral(argument) ? StringEqualsEmptyStringInspection.getCheckedExpression(this.myUseIsEmpty, qualifier) : StringEqualsEmptyStringInspection.getCheckedExpression(this.myUseIsEmpty, argument);
            CommentTracker ct = new CommentTracker();
            if (this.myAddNullCheck) {
                newExpression = new StringBuilder(ct.text(checkedExpression, 9));
                newExpression.append("!=null&&");
            } else {
                newExpression = new StringBuilder();
            }
            PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)call.getParent(), PsiExpression.class);
            String expressionText = ct.text(checkedExpression, 1);
            if (parent != null && BoolUtils.isNegation(parent)) {
                expressionToReplace = parent;
                if (this.myUseIsEmpty) {
                    newExpression.append('!').append(expressionText).append(".isEmpty()");
                } else {
                    newExpression.append(expressionText).append(".length()!=0");
                }
            } else {
                expressionToReplace = call;
                if (this.myUseIsEmpty) {
                    newExpression.append(expressionText).append(".isEmpty()");
                } else {
                    newExpression.append(expressionText).append(".length()==0");
                }
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expressionToReplace, newExpression.toString(), ct);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

