/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NativeMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NativeMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("native.method.problem.descriptor", new Object[0]);
        if (string == null) {
            NativeMethodsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NativeMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/NativeMethodsInspection", "buildErrorString"));
    }

    private static class NativeMethodVisitor
    extends BaseInspectionVisitor {
        private NativeMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NativeMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.hasModifierProperty("native")) {
                return;
            }
            this.registerModifierError("native", (PsiModifierListOwner)method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/portability/NativeMethodsInspection$NativeMethodVisitor", "visitMethod"));
        }
    }
}

