/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityCheck {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));
    @NotNull
    private final PsiExpression myLeft;
    @NotNull
    private final PsiExpression myRight;
    private final boolean myLeftDereferenced;

    private EqualityCheck(@NotNull PsiExpression left, @NotNull PsiExpression right, boolean leftDereferenced) {
        if (left == null) {
            EqualityCheck.$$$reportNull$$$0(0);
        }
        if (right == null) {
            EqualityCheck.$$$reportNull$$$0(1);
        }
        this.myLeft = left;
        this.myRight = right;
        this.myLeftDereferenced = leftDereferenced;
    }

    @Nullable
    @Contract(value="null -> null")
    public static EqualityCheck from(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (MethodCallUtils.isEqualsCall(call)) {
                PsiExpression left = call.getMethodExpression().getQualifierExpression();
                PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                if (left == null || right == null) {
                    return null;
                }
                return new EqualityCheck(left, right, true);
            }
            if (OBJECT_EQUALS.test(call)) {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                return new EqualityCheck(args[0], args[1], false);
            }
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)expression2;
            EqualityCheck nestedCheck = EqualityCheck.from(ternary.getThenExpression());
            PsiExpression other = ternary.getElseExpression();
            boolean equalsToNull = false;
            if (nestedCheck == null) {
                nestedCheck = EqualityCheck.from(ternary.getElseExpression());
                other = ternary.getThenExpression();
                equalsToNull = true;
            }
            if (nestedCheck != null && nestedCheck.isLeftDereferenced() && other != null) {
                PsiReferenceExpression rightRef;
                PsiReferenceExpression leftRef = ExpressionUtils.getReferenceExpressionFromNullComparison(ternary.getCondition(), equalsToNull);
                EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
                if (equivalence.expressionsAreEquivalent((PsiExpression)leftRef, nestedCheck.getLeft()) && equivalence.expressionsAreEquivalent((PsiExpression)(rightRef = ExpressionUtils.getReferenceExpressionFromNullComparison(other, true)), nestedCheck.getRight())) {
                    return new EqualityCheck(nestedCheck.getLeft(), nestedCheck.getRight(), false);
                }
            }
        }
        return null;
    }

    @NotNull
    public PsiExpression getLeft() {
        PsiExpression psiExpression = this.myLeft;
        if (psiExpression == null) {
            EqualityCheck.$$$reportNull$$$0(2);
        }
        return psiExpression;
    }

    @NotNull
    public PsiExpression getRight() {
        PsiExpression psiExpression = this.myRight;
        if (psiExpression == null) {
            EqualityCheck.$$$reportNull$$$0(3);
        }
        return psiExpression;
    }

    public boolean isLeftDereferenced() {
        return this.myLeftDereferenced;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/EqualityCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/EqualityCheck";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeft";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

