/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    protected static final Match EXACT_MATCH = new Match(true);
    protected static final Match EXACT_MISMATCH = new Match(false);
    private static final EquivalenceChecker ourCanonicalPsiEquivalence = new EquivalenceChecker();
    private static final Comparator<PsiMember> MEMBER_COMPARATOR = Comparator.comparing(NavigationItem::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(PsiElement::getText);
    private static final Comparator<PsiExpression> EXPRESSION_COMPARATOR = Comparator.comparing(expression2 -> PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), Comparator.nullsFirst(Comparator.comparing(PsiElement::getText)));

    protected EquivalenceChecker() {
    }

    public static EquivalenceChecker getCanonicalPsiEquivalence() {
        return ourCanonicalPsiEquivalence;
    }

    public boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        return this.statementsMatch(statement1, statement2).isExactMatch();
    }

    public Match statementsMatch(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        statement1 = ControlFlowUtils.stripBraces(statement1);
        statement2 = ControlFlowUtils.stripBraces(statement2);
        if (statement1 == null || statement2 == null) {
            return Match.exact(statement1 == statement2);
        }
        if (statement1.getClass() != statement2.getClass()) {
            return EXACT_MISMATCH;
        }
        if (statement1 instanceof PsiAssertStatement) {
            return this.assertStatementsMatch((PsiAssertStatement)statement1, (PsiAssertStatement)statement2);
        }
        if (statement1 instanceof PsiBlockStatement) {
            return this.blockStatementsMatch((PsiBlockStatement)statement1, (PsiBlockStatement)statement2);
        }
        if (statement1 instanceof PsiBreakStatement) {
            return this.breakStatementsMatch((PsiBreakStatement)statement1, (PsiBreakStatement)statement2);
        }
        if (statement1 instanceof PsiContinueStatement) {
            return this.continueStatementsMatch((PsiContinueStatement)statement1, (PsiContinueStatement)statement2);
        }
        if (statement1 instanceof PsiDeclarationStatement) {
            return this.declarationStatementsMatch((PsiDeclarationStatement)statement1, (PsiDeclarationStatement)statement2);
        }
        if (statement1 instanceof PsiConditionalLoopStatement) {
            return this.conditionalLoopStatementsMatch((PsiConditionalLoopStatement)statement1, (PsiConditionalLoopStatement)statement2);
        }
        if (statement1 instanceof PsiEmptyStatement) {
            return EXACT_MATCH;
        }
        if (statement1 instanceof PsiExpressionListStatement) {
            return this.expressionListStatementsMatch((PsiExpressionListStatement)statement1, (PsiExpressionListStatement)statement2);
        }
        if (statement1 instanceof PsiExpressionStatement) {
            return this.expressionStatementsMatch((PsiExpressionStatement)statement1, (PsiExpressionStatement)statement2);
        }
        if (statement1 instanceof PsiForeachStatement) {
            return this.forEachStatementsMatch((PsiForeachStatement)statement1, (PsiForeachStatement)statement2);
        }
        if (statement1 instanceof PsiIfStatement) {
            return this.ifStatementsMatch((PsiIfStatement)statement1, (PsiIfStatement)statement2);
        }
        if (statement1 instanceof PsiLabeledStatement) {
            return this.labeledStatementsMatch((PsiLabeledStatement)statement1, (PsiLabeledStatement)statement2);
        }
        if (statement1 instanceof PsiReturnStatement) {
            return this.returnStatementsMatch((PsiReturnStatement)statement1, (PsiReturnStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchStatement) {
            return this.switchBlocksMatch((PsiSwitchBlock)((PsiSwitchStatement)statement1), (PsiSwitchBlock)((PsiSwitchStatement)statement2));
        }
        if (statement1 instanceof PsiSwitchLabelStatementBase && statement2 instanceof PsiSwitchLabelStatementBase) {
            return this.switchLabelStatementsMatch((PsiSwitchLabelStatementBase)statement1, (PsiSwitchLabelStatementBase)statement2);
        }
        if (statement1 instanceof PsiSynchronizedStatement) {
            return this.synchronizedStatementsMatch((PsiSynchronizedStatement)statement1, (PsiSynchronizedStatement)statement2);
        }
        if (statement1 instanceof PsiThrowStatement) {
            return this.throwStatementsMatch((PsiThrowStatement)statement1, (PsiThrowStatement)statement2);
        }
        if (statement1 instanceof PsiTryStatement) {
            return this.tryStatementsMatch((PsiTryStatement)statement1, (PsiTryStatement)statement2);
        }
        String text1 = statement1.getText();
        String text2 = statement2.getText();
        return Match.exact(text1.equals(text2));
    }

    protected Match declarationStatementsMatch(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        PsiElement[] elements2;
        PsiElement[] elements1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(1);
        }
        if ((elements1 = statement1.getDeclaredElements()).length != (elements2 = statement2.getDeclaredElements()).length) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < elements1.length; ++i) {
            PsiElement element1 = elements1[i];
            PsiElement element2 = elements2[i];
            if (element1 instanceof PsiLocalVariable && element2 instanceof PsiLocalVariable && this.localVariablesAreEquivalent((PsiLocalVariable)element1, (PsiLocalVariable)element2).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match localVariablesAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
        if (localVariable1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(2);
        }
        if (localVariable2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(3);
        }
        return this.variablesAreEquivalent((PsiVariable)localVariable1, (PsiVariable)localVariable2);
    }

    protected Match variablesAreEquivalent(@NotNull PsiVariable variable1, @NotNull PsiVariable variable2) {
        if (variable1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(4);
        }
        if (variable2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(5);
        }
        if (!this.variableSignatureMatch(variable1, variable2)) {
            return EXACT_MISMATCH;
        }
        PsiExpression initializer1 = variable1.getInitializer();
        PsiExpression initializer2 = variable2.getInitializer();
        return this.expressionsMatch(initializer1, initializer2).partialIfExactMismatch((PsiElement)initializer1, (PsiElement)initializer2);
    }

    private boolean variableSignatureMatch(@NotNull PsiVariable variable1, @NotNull PsiVariable variable2) {
        PsiType type2;
        PsiType type1;
        if (variable1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(6);
        }
        if (variable2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(7);
        }
        if (!this.typesAreEquivalent(type1 = variable1.getType(), type2 = variable2.getType())) {
            return false;
        }
        PsiModifierList modifierList1 = variable1.getModifierList();
        PsiModifierList modifierList2 = variable2.getModifierList();
        if (modifierList1 == null || modifierList2 == null) {
            return modifierList1 == modifierList2;
        }
        if (!EquivalenceChecker.modifierListsAreEquivalent(modifierList1, modifierList2)) {
            return false;
        }
        this.markDeclarationsAsEquivalent((PsiElement)variable1, (PsiElement)variable2);
        return true;
    }

    protected Match tryStatementsMatch(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        PsiCodeBlock tryBlock1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(8);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(9);
        }
        if (!this.codeBlocksMatch(tryBlock1 = statement1.getTryBlock(), tryBlock2 = statement2.getTryBlock()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!this.codeBlocksMatch(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < catchBlocks2.length; ++i) {
            if (this.codeBlocksMatch(catchBlocks1[i], catchBlocks2[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        PsiResourceList resourceList1 = statement1.getResourceList();
        PsiResourceList resourceList2 = statement2.getResourceList();
        if (resourceList1 == null || resourceList2 == null) {
            return Match.exact(resourceList1 == resourceList2);
        }
        if (resourceList1.getResourceVariablesCount() != resourceList2.getResourceVariablesCount()) {
            return EXACT_MISMATCH;
        }
        List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
        List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
        int size = resources1.size();
        for (int i = 0; i < size; ++i) {
            PsiResourceListElement resource1 = (PsiResourceListElement)resources1.get(i);
            PsiResourceListElement resource2 = (PsiResourceListElement)resources2.get(i);
            if (resource1 instanceof PsiResourceVariable && resource2 instanceof PsiResourceVariable) {
                if (this.variablesAreEquivalent((PsiVariable)((PsiLocalVariable)resource1), (PsiVariable)((PsiLocalVariable)resource2)).isExactMatch()) continue;
                return EXACT_MISMATCH;
            }
            if (resource1 instanceof PsiResourceExpression && resource2 instanceof PsiResourceExpression) {
                if (this.expressionsMatch(((PsiResourceExpression)resource1).getExpression(), ((PsiResourceExpression)resource2).getExpression()).isExactMatch()) continue;
                return EXACT_MISMATCH;
            }
            return EXACT_MISMATCH;
        }
        PsiParameter[] catchParameters1 = statement1.getCatchBlockParameters();
        if (catchParameters1.length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < catchParameters2.length; ++i) {
            if (this.variablesAreEquivalent((PsiVariable)catchParameters2[i], (PsiVariable)catchParameters1[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    public boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null || type2 == null) {
            return type1 == type2;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    protected Match conditionalLoopStatementsMatch(@NotNull PsiConditionalLoopStatement statement1, @NotNull PsiConditionalLoopStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(10);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(11);
        }
        if (statement1 instanceof PsiForStatement) {
            PsiStatement update2;
            PsiStatement initialization2;
            PsiStatement initialization1 = ((PsiForStatement)statement1).getInitialization();
            if (!this.statementsMatch(initialization1, initialization2 = ((PsiForStatement)statement2).getInitialization()).isExactMatch()) {
                return EXACT_MISMATCH;
            }
            PsiStatement update1 = ((PsiForStatement)statement1).getUpdate();
            if (!this.statementsMatch(update1, update2 = ((PsiForStatement)statement2).getUpdate()).isExactMatch()) {
                return EXACT_MISMATCH;
            }
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        Match conditionEquivalence = this.expressionsMatch(condition1, condition2);
        Match bodyEquivalence = this.statementsMatch(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(bodyEquivalence, conditionEquivalence, (PsiElement)body1, (PsiElement)body2, (PsiElement)condition1, (PsiElement)condition2);
    }

    protected Match forEachStatementsMatch(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        String name2;
        PsiExpression value2;
        PsiExpression value1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(12);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(13);
        }
        if (!this.expressionsMatch(value1 = statement1.getIteratedValue(), value2 = statement2.getIteratedValue()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (!name1.equals(name2 = parameter2.getName())) {
            return EXACT_MISMATCH;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return EXACT_MISMATCH;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return this.statementsMatch(body1, body2).partialIfExactMismatch((PsiElement)body1, (PsiElement)body2);
    }

    protected Match switchBlocksMatch(@NotNull PsiSwitchBlock switchBlock1, @NotNull PsiSwitchBlock switchBlock2) {
        PsiCodeBlock body2;
        PsiCodeBlock body1;
        if (switchBlock1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(14);
        }
        if (switchBlock2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(15);
        }
        if (!this.codeBlocksAreEquivalent(body1 = switchBlock1.getBody(), body2 = switchBlock2.getBody())) {
            return EXACT_MISMATCH;
        }
        PsiExpression switchExpression1 = switchBlock1.getExpression();
        PsiExpression switchExpression2 = switchBlock2.getExpression();
        return this.expressionsMatch(switchExpression1, switchExpression2).partialIfExactMismatch((PsiElement)switchExpression1, (PsiElement)switchExpression2);
    }

    protected Match assertStatementsMatch(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(16);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(17);
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        Match condEq = this.expressionsMatch(condition1, condition2);
        Match exprEq = this.expressionsMatch(description1, description2);
        return EquivalenceChecker.getComplexElementDecision(condEq, exprEq, (PsiElement)condition1, (PsiElement)condition2, (PsiElement)description1, (PsiElement)description2);
    }

    protected Match synchronizedStatementsMatch(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(18);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(19);
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        Match lockEq = this.expressionsMatch(lock1, lock2);
        Match blockEq = this.codeBlocksMatch(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(blockEq, lockEq, (PsiElement)body1, (PsiElement)body2, (PsiElement)lock1, (PsiElement)lock2);
    }

    protected Match blockStatementsMatch(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(20);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(21);
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return this.codeBlocksMatch(block1, block2);
    }

    protected Match breakStatementsMatch(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(22);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(23);
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        return EquivalenceChecker.matchLabels(identifier1, identifier2);
    }

    protected Match continueStatementsMatch(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(24);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(25);
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        return EquivalenceChecker.matchLabels(identifier1, identifier2);
    }

    private static Match matchLabels(PsiIdentifier identifier1, PsiIdentifier identifier2) {
        if (identifier1 == null || identifier2 == null) {
            return Match.exact(identifier1 == identifier2);
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Match.exact(text1.equals(text2));
    }

    protected Match switchLabelStatementsMatch(@NotNull PsiSwitchLabelStatementBase statement1, @NotNull PsiSwitchLabelStatementBase statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(26);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(27);
        }
        if (statement1.isDefaultCase() != statement2.isDefaultCase()) {
            return EXACT_MISMATCH;
        }
        boolean rule1 = statement1 instanceof PsiSwitchLabeledRuleStatement;
        boolean rule2 = statement2 instanceof PsiSwitchLabeledRuleStatement;
        if (rule1 && rule2) {
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement1 = (PsiSwitchLabeledRuleStatement)statement1;
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement2 = (PsiSwitchLabeledRuleStatement)statement2;
            if (!this.statementsAreEquivalent(switchLabeledRuleStatement1.getBody(), switchLabeledRuleStatement2.getBody())) {
                return EXACT_MISMATCH;
            }
        } else if (rule1 || rule2) {
            return EXACT_MISMATCH;
        }
        PsiExpressionList caseValues1 = statement1.getCaseValues();
        PsiExpressionList caseValues2 = statement2.getCaseValues();
        if (caseValues1 == null || caseValues2 == null) {
            return Match.exact(caseValues1 == caseValues2);
        }
        return this.expressionsAreEquivalent(caseValues1.getExpressions(), caseValues2.getExpressions(), true);
    }

    protected Match labeledStatementsMatch(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(28);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(29);
        }
        return Match.exact(statement1.getName().equals(statement2.getName()));
    }

    public boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        return this.codeBlocksMatch(block1, block2).isExactMatch();
    }

    protected Match codeBlocksMatch(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null || block2 == null) {
            return Match.exact(block1 == block2);
        }
        List<PsiStatement> statements1 = EquivalenceChecker.collectStatements(block1, (List<PsiStatement>)new SmartList());
        List<PsiStatement> statements2 = EquivalenceChecker.collectStatements(block2, (List<PsiStatement>)new SmartList());
        int size = statements1.size();
        if (size != statements2.size()) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < size; ++i) {
            if (this.statementsMatch(statements2.get(i), statements1.get(i)).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    private static List<PsiStatement> collectStatements(PsiCodeBlock codeBlock, List<PsiStatement> out) {
        for (PsiStatement statement : codeBlock.getStatements()) {
            if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                EquivalenceChecker.collectStatements(blockStatement.getCodeBlock(), out);
                continue;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            out.add(statement);
        }
        return out;
    }

    protected Match ifStatementsMatch(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(30);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(31);
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        Match conditionEq = this.expressionsMatch(condition1, condition2);
        Match thenEq = this.statementsMatch(thenBranch1, thenBranch2);
        Match elseEq = this.statementsMatch(elseBranch1, elseBranch2);
        return conditionEq.combine(thenEq).combine(elseEq);
    }

    protected Match expressionStatementsMatch(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(32);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(33);
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return this.expressionsMatch(expression1, expression2);
    }

    protected Match returnStatementsMatch(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        PsiExpression returnValue2;
        PsiExpression returnValue1;
        Match match;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(34);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(35);
        }
        if ((match = this.expressionsMatch(returnValue1 = statement1.getReturnValue(), returnValue2 = statement2.getReturnValue())).isExactMismatch()) {
            return new Match((PsiElement)returnValue1, (PsiElement)returnValue2);
        }
        return match;
    }

    protected Match throwStatementsMatch(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(36);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(37);
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return this.expressionsMatch(exception1, exception2);
    }

    protected Match expressionListStatementsMatch(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(38);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(39);
        }
        PsiExpression[] expressions1 = statement1.getExpressionList().getExpressions();
        PsiExpression[] expressions2 = statement2.getExpressionList().getExpressions();
        return this.expressionsAreEquivalent(expressions1, expressions2, false);
    }

    public boolean expressionsAreEquivalent(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        return this.expressionsMatch(expression1, expression2).isExactMatch();
    }

    public Match expressionsMatch(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        if (expression1 == expression2) {
            return EXACT_MATCH;
        }
        expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression1);
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (expression1 == null || expression2 == null) {
            return Match.exact(expression1 == expression2);
        }
        if (expression1.getClass() != expression2.getClass()) {
            return EXACT_MISMATCH;
        }
        if (expression1 instanceof PsiThisExpression) {
            return this.thisExpressionsMatch((PsiThisExpression)expression1, (PsiThisExpression)expression2);
        }
        if (expression1 instanceof PsiSuperExpression) {
            return EXACT_MATCH;
        }
        if (expression1 instanceof PsiLiteralExpression) {
            return this.literalExpressionsMatch((PsiLiteralExpression)expression1, (PsiLiteralExpression)expression2);
        }
        if (expression1 instanceof PsiClassObjectAccessExpression) {
            return this.classObjectAccessExpressionsMatch((PsiClassObjectAccessExpression)expression1, (PsiClassObjectAccessExpression)expression2);
        }
        if (expression1 instanceof PsiReferenceExpression) {
            return this.referenceExpressionsMatch((PsiReferenceExpression)expression1, (PsiReferenceExpression)expression2);
        }
        if (expression1 instanceof PsiMethodCallExpression) {
            return this.methodCallExpressionsMatch((PsiMethodCallExpression)expression1, (PsiMethodCallExpression)expression2);
        }
        if (expression1 instanceof PsiNewExpression) {
            return this.newExpressionsMatch((PsiNewExpression)expression1, (PsiNewExpression)expression2);
        }
        if (expression1 instanceof PsiArrayInitializerExpression) {
            return this.arrayInitializerExpressionsMatch((PsiArrayInitializerExpression)expression1, (PsiArrayInitializerExpression)expression2);
        }
        if (expression1 instanceof PsiTypeCastExpression) {
            return this.typeCastExpressionsMatch((PsiTypeCastExpression)expression1, (PsiTypeCastExpression)expression2);
        }
        if (expression1 instanceof PsiArrayAccessExpression) {
            return this.arrayAccessExpressionsMatch((PsiArrayAccessExpression)expression2, (PsiArrayAccessExpression)expression1);
        }
        if (expression1 instanceof PsiUnaryExpression) {
            return this.unaryExpressionsMatch((PsiUnaryExpression)expression1, (PsiUnaryExpression)expression2);
        }
        if (expression1 instanceof PsiBinaryExpression) {
            return this.binaryExpressionsMatch((PsiBinaryExpression)expression1, (PsiBinaryExpression)expression2);
        }
        if (expression1 instanceof PsiPolyadicExpression) {
            return this.polyadicExpressionsMatch((PsiPolyadicExpression)expression1, (PsiPolyadicExpression)expression2);
        }
        if (expression1 instanceof PsiAssignmentExpression) {
            return this.assignmentExpressionsMatch((PsiAssignmentExpression)expression1, (PsiAssignmentExpression)expression2);
        }
        if (expression1 instanceof PsiConditionalExpression) {
            return this.conditionalExpressionsMatch((PsiConditionalExpression)expression1, (PsiConditionalExpression)expression2);
        }
        if (expression1 instanceof PsiInstanceOfExpression) {
            return this.instanceOfExpressionsMatch((PsiInstanceOfExpression)expression1, (PsiInstanceOfExpression)expression2);
        }
        if (expression1 instanceof PsiLambdaExpression) {
            return this.lambdaExpressionsMatch((PsiLambdaExpression)expression1, (PsiLambdaExpression)expression2);
        }
        if (expression1 instanceof PsiSwitchExpression) {
            return this.switchBlocksMatch((PsiSwitchBlock)((PsiSwitchExpression)expression1), (PsiSwitchBlock)((PsiSwitchExpression)expression2));
        }
        return EXACT_MISMATCH;
    }

    @NotNull
    private Match thisExpressionsMatch(@NotNull PsiThisExpression thisExpression1, @NotNull PsiThisExpression thisExpression2) {
        if (thisExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(40);
        }
        if (thisExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(41);
        }
        PsiJavaCodeReferenceElement qualifier1 = thisExpression1.getQualifier();
        PsiJavaCodeReferenceElement qualifier2 = thisExpression2.getQualifier();
        if (qualifier1 != null && qualifier2 != null) {
            Match match = this.javaCodeReferenceElementsMatch(qualifier1, qualifier2);
            if (match == null) {
                EquivalenceChecker.$$$reportNull$$$0(42);
            }
            return match;
        }
        if (qualifier1 != qualifier2) {
            Match match = EXACT_MISMATCH;
            if (match == null) {
                EquivalenceChecker.$$$reportNull$$$0(43);
            }
            return match;
        }
        PsiClass containingClass1 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisExpression1, PsiClass.class);
        PsiClass containingClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisExpression2, PsiClass.class);
        if (containingClass1 == null || containingClass2 == null) {
            Match match = EXACT_MISMATCH;
            if (match == null) {
                EquivalenceChecker.$$$reportNull$$$0(44);
            }
            return match;
        }
        Match match = Match.exact(containingClass1 == containingClass2 || containingClass2.isInheritor(containingClass1, false) || containingClass1.isInheritor(containingClass2, false));
        if (match == null) {
            EquivalenceChecker.$$$reportNull$$$0(45);
        }
        return match;
    }

    protected Match lambdaExpressionsMatch(PsiLambdaExpression expression1, PsiLambdaExpression expression2) {
        PsiParameter[] parameters2;
        PsiParameterList parameterList1 = expression1.getParameterList();
        PsiParameterList parameterList2 = expression2.getParameterList();
        PsiParameter[] parameters1 = parameterList1.getParameters();
        if (parameters1.length != (parameters2 = parameterList2.getParameters()).length) {
            return EXACT_MISMATCH;
        }
        int length = parameters1.length;
        for (int i = 0; i < length; ++i) {
            if (this.variablesAreEquivalent((PsiVariable)parameters1[i], (PsiVariable)parameters2[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        PsiElement body1 = EquivalenceChecker.unwrapLambdaBody(expression1.getBody());
        PsiElement body2 = EquivalenceChecker.unwrapLambdaBody(expression2.getBody());
        Match match = body1 instanceof PsiCodeBlock && body2 instanceof PsiCodeBlock ? this.codeBlocksMatch((PsiCodeBlock)body1, (PsiCodeBlock)body2) : (body1 instanceof PsiExpression && body2 instanceof PsiExpression ? this.expressionsMatch((PsiExpression)body1, (PsiExpression)body2) : EXACT_MISMATCH);
        return match == EXACT_MISMATCH ? new Match(body1, body2) : match;
    }

    private static PsiElement unwrapLambdaBody(PsiElement element) {
        PsiCodeBlock codeBlock;
        PsiStatement[] statements;
        while (element instanceof PsiCodeBlock && (statements = (codeBlock = (PsiCodeBlock)element).getStatements()).length == 1) {
            PsiStatement statement = statements[0];
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue();
            }
            if (statement instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)statement).getExpression();
            }
            if (!(statement instanceof PsiBlockStatement)) break;
            element = ((PsiBlockStatement)statement).getCodeBlock();
        }
        return element;
    }

    protected Match literalExpressionsMatch(PsiLiteralExpression expression1, PsiLiteralExpression expression2) {
        if (PsiType.NULL.equals((Object)expression1.getType()) && PsiType.NULL.equals((Object)expression2.getType())) {
            return EXACT_MATCH;
        }
        Object value1 = expression1.getValue();
        Object value2 = expression2.getValue();
        return value1 == null || value2 == null ? EXACT_MISMATCH : Match.exact(value1.equals(value2));
    }

    protected Match classObjectAccessExpressionsMatch(PsiClassObjectAccessExpression expression1, PsiClassObjectAccessExpression expression2) {
        PsiTypeElement operand1 = expression1.getOperand();
        PsiTypeElement operand2 = expression2.getOperand();
        return this.typeElementsAreEquivalent(operand1, operand2);
    }

    protected Match referenceExpressionsMatch(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement element1 = referenceExpression1.resolve();
        PsiElement element2 = referenceExpression2.resolve();
        if (element1 != null) {
            if (element2 == null || !this.equivalentDeclarations(element1, element2) && !element1.equals(element2)) {
                return EXACT_MISMATCH;
            }
        } else {
            return EXACT_MISMATCH;
        }
        if (element1 instanceof PsiMember) {
            PsiMember member1 = (PsiMember)element1;
            if (member1.hasModifierProperty("static")) {
                return EXACT_MATCH;
            }
            if (member1 instanceof PsiClass) {
                return EXACT_MATCH;
            }
        } else {
            return EXACT_MATCH;
        }
        PsiExpression qualifier1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)referenceExpression1.getQualifierExpression());
        PsiExpression qualifier2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)referenceExpression2.getQualifierExpression());
        if (qualifier1 != null && !(qualifier1 instanceof PsiThisExpression) && !(qualifier1 instanceof PsiSuperExpression)) {
            if (qualifier2 == null) {
                return EXACT_MISMATCH;
            }
            Match match = this.expressionsMatch(qualifier1, qualifier2);
            if (!match.isExactMatch() && PsiUtil.isArrayClass((PsiElement)((PsiMember)element1).getContainingClass()) && !(GenericsUtil.getLeastUpperBound((PsiType)qualifier1.getType(), (PsiType)qualifier2.getType(), (PsiManager)referenceExpression1.getManager()) instanceof PsiArrayType)) {
                return EXACT_MISMATCH;
            }
            if (match.isExactMismatch()) {
                return new Match((PsiElement)qualifier1, (PsiElement)qualifier2);
            }
            return match;
        }
        if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match instanceOfExpressionsMatch(PsiInstanceOfExpression instanceOfExpression1, PsiInstanceOfExpression instanceOfExpression2) {
        PsiExpression operand2;
        PsiExpression operand1 = instanceOfExpression1.getOperand();
        if (!this.expressionsMatch(operand1, operand2 = instanceOfExpression2.getOperand()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiTypeElement typeElement1 = instanceOfExpression1.getCheckType();
        PsiTypeElement typeElement2 = instanceOfExpression2.getCheckType();
        return this.typeElementsAreEquivalent(typeElement1, typeElement2);
    }

    protected Match typeElementsAreEquivalent(PsiTypeElement typeElement1, PsiTypeElement typeElement2) {
        if (typeElement1 == null || typeElement2 == null) {
            return Match.exact(typeElement1 == typeElement2);
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return Match.exact(this.typesAreEquivalent(type1, type2));
    }

    protected Match methodCallExpressionsMatch(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
        PsiExpression lastArg;
        PsiElement leftDiff;
        PsiReferenceExpression methodExpression2;
        PsiReferenceExpression methodExpression1;
        Match match;
        if (methodCallExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(46);
        }
        if (methodCallExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(47);
        }
        if ((match = this.expressionsMatch((PsiExpression)(methodExpression1 = methodCallExpression1.getMethodExpression()), (PsiExpression)(methodExpression2 = methodCallExpression2.getMethodExpression()))).isExactMismatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpression[] args1 = methodCallExpression1.getArgumentList().getExpressions();
        PsiExpression[] args2 = methodCallExpression2.getArgumentList().getExpressions();
        match = match.combine(this.expressionsAreEquivalent(args1, args2, false));
        if (args1.length != 0 && match.isPartialMatch() && Comparing.equal((Object)(leftDiff = match.getLeftDiff()), (Object)(lastArg = args1[args1.length - 1]))) {
            PsiType type1 = lastArg.getType();
            PsiType type2 = args2[args2.length - 1].getType();
            if (type2 instanceof PsiArrayType && !(type1 instanceof PsiArrayType)) {
                return EXACT_MISMATCH;
            }
            if (type1 instanceof PsiArrayType && !(type2 instanceof PsiArrayType)) {
                return EXACT_MISMATCH;
            }
        }
        return match;
    }

    protected Match newExpressionsMatch(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
        PsiExpression qualifier2;
        PsiMethod constructor2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        PsiExpression[] arrayDimensions1;
        if (newExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(48);
        }
        if (newExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(49);
        }
        PsiJavaCodeReferenceElement classReference1 = newExpression1.getClassReference();
        PsiJavaCodeReferenceElement classReference2 = newExpression2.getClassReference();
        if (classReference1 != null && classReference2 != null) {
            if (this.javaCodeReferenceElementsMatch(classReference1, classReference2) == EXACT_MISMATCH) {
                return EXACT_MISMATCH;
            }
        } else {
            if (classReference1 != classReference2) {
                return EXACT_MISMATCH;
            }
            if (!this.typesAreEquivalent(newExpression1.getType(), newExpression2.getType())) {
                return EXACT_MISMATCH;
            }
        }
        if (!this.expressionsAreEquivalent(arrayDimensions1 = newExpression1.getArrayDimensions(), arrayDimensions2 = newExpression2.getArrayDimensions(), false).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExpression1.getArrayInitializer();
        if (!this.expressionsMatch((PsiExpression)arrayInitializer1, (PsiExpression)(arrayInitializer2 = newExpression2.getArrayInitializer())).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiMethod constructor1 = newExpression1.resolveConstructor();
        if (!Comparing.equal((Object)constructor1, (Object)(constructor2 = newExpression2.resolveConstructor()))) {
            return EXACT_MISMATCH;
        }
        PsiExpression qualifier1 = newExpression1.getQualifier();
        if (!this.expressionsMatch(qualifier1, qualifier2 = newExpression2.getQualifier()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpressionList argumentList1 = newExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        PsiAnonymousClass anonymousClass1 = newExpression1.getAnonymousClass();
        PsiAnonymousClass anonymousClass2 = newExpression2.getAnonymousClass();
        if (anonymousClass1 != null || anonymousClass2 != null) {
            if (anonymousClass1 != null && anonymousClass2 != null) {
                return this.classesMatch(anonymousClass1, anonymousClass2);
            }
            return EXACT_MISMATCH;
        }
        return this.expressionsAreEquivalent(args1, args2, false);
    }

    private Match classesMatch(PsiAnonymousClass class1, PsiAnonymousClass class2) {
        PsiElement child2;
        PsiElement child1;
        int i;
        PsiJavaCodeReferenceElement baseClass2;
        PsiJavaCodeReferenceElement baseClass1 = class1.getBaseClassReference();
        Match match = this.javaCodeReferenceElementsMatch(baseClass1, baseClass2 = class2.getBaseClassReference());
        if (!match.isExactMatch()) {
            return EXACT_MISMATCH;
        }
        List children1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)class1, PsiMember.class);
        List children2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)class2, PsiMember.class);
        int size = children1.size();
        if (size != children2.size()) {
            return EXACT_MISMATCH;
        }
        children1.sort(MEMBER_COMPARATOR);
        children2.sort(MEMBER_COMPARATOR);
        for (i = 0; i < size; ++i) {
            child1 = (PsiElement)children1.get(i);
            child2 = (PsiElement)children2.get(i);
            if (!(child1 instanceof PsiMethod && child2 instanceof PsiMethod ? !this.methodSignaturesMatch((PsiMethod)child1, (PsiMethod)child2) : child1 instanceof PsiField && child2 instanceof PsiField && !this.variableSignatureMatch((PsiVariable)((PsiField)child1), (PsiVariable)((PsiField)child2)))) continue;
            return EXACT_MISMATCH;
        }
        for (i = 0; i < size; ++i) {
            child1 = (PsiElement)children1.get(i);
            child2 = (PsiElement)children2.get(i);
            if (!(child1 instanceof PsiMethod && child2 instanceof PsiMethod ? !this.codeBlocksAreEquivalent(((PsiMethod)child1).getBody(), ((PsiMethod)child2).getBody()) : (child1 instanceof PsiField && child2 instanceof PsiField ? !this.expressionsAreEquivalent(((PsiField)child1).getInitializer(), ((PsiField)child2).getInitializer()) : (child1 instanceof PsiClassInitializer && child2 instanceof PsiClassInitializer ? !this.classInitializersMatch((PsiClassInitializer)child1, (PsiClassInitializer)child2).isExactMatch() : !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child1, (PsiElement)child2))))) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    private Match classInitializersMatch(PsiClassInitializer classInitializer1, PsiClassInitializer classInitializer2) {
        if (!EquivalenceChecker.modifierListsAreEquivalent(classInitializer1.getModifierList(), classInitializer2.getModifierList())) {
            return EXACT_MISMATCH;
        }
        return this.codeBlocksMatch(classInitializer1.getBody(), classInitializer2.getBody());
    }

    private boolean methodSignaturesMatch(PsiMethod method1, PsiMethod method2) {
        PsiClassType[] thrownTypes2;
        PsiParameter[] parameters2;
        if (!method1.getName().equals(method2.getName()) || !this.typesAreEquivalent(method1.getReturnType(), method2.getReturnType())) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int j = 0; j < parameters1.length; ++j) {
            if (this.variableSignatureMatch((PsiVariable)parameters1[j], (PsiVariable)parameters2[j])) continue;
            return false;
        }
        PsiClassType[] thrownTypes1 = method1.getThrowsList().getReferencedTypes();
        if (thrownTypes1.length != (thrownTypes2 = method2.getThrowsList().getReferencedTypes()).length) {
            return false;
        }
        for (int i = 0; i < thrownTypes1.length; ++i) {
            if (this.typesAreEquivalent((PsiType)thrownTypes1[i], (PsiType)thrownTypes2[i])) continue;
            return false;
        }
        this.markDeclarationsAsEquivalent((PsiElement)method1, (PsiElement)method2);
        return true;
    }

    private Match javaCodeReferenceElementsMatch(@NotNull PsiJavaCodeReferenceElement classReference1, @NotNull PsiJavaCodeReferenceElement classReference2) {
        PsiType[] parameters2;
        PsiType[] parameters1;
        if (classReference1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(50);
        }
        if (classReference2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(51);
        }
        if ((parameters1 = classReference1.getTypeParameters()).length != (parameters2 = classReference2.getTypeParameters()).length) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            if (this.typesAreEquivalent(parameters1[i], parameters2[i])) continue;
            return EXACT_MISMATCH;
        }
        PsiElement target1 = classReference1.resolve();
        PsiElement target2 = classReference2.resolve();
        return target1 == null && target2 == null ? Match.exact(classReference1.getText().equals(classReference2.getText())) : Match.exact(target1 == target2);
    }

    protected Match arrayInitializerExpressionsMatch(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
        if (arrayInitializerExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(52);
        }
        if (arrayInitializerExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(53);
        }
        PsiExpression[] initializers1 = arrayInitializerExpression1.getInitializers();
        PsiExpression[] initializers2 = arrayInitializerExpression2.getInitializers();
        return this.expressionsAreEquivalent(initializers1, initializers2, false);
    }

    protected Match typeCastExpressionsMatch(@NotNull PsiTypeCastExpression typeCastExpression1, @NotNull PsiTypeCastExpression typeCastExpression2) {
        PsiTypeElement typeElement2;
        PsiTypeElement typeElement1;
        if (typeCastExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(54);
        }
        if (typeCastExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(55);
        }
        if (!this.typeElementsAreEquivalent(typeElement1 = typeCastExpression1.getCastType(), typeElement2 = typeCastExpression2.getCastType()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpression operand1 = typeCastExpression1.getOperand();
        PsiExpression operand2 = typeCastExpression2.getOperand();
        if (operand1 instanceof PsiFunctionalExpression || operand2 instanceof PsiFunctionalExpression) {
            return EXACT_MISMATCH;
        }
        return this.expressionsMatch(operand1, operand2).partialIfExactMismatch((PsiElement)operand1, (PsiElement)operand2);
    }

    protected Match arrayAccessExpressionsMatch(@NotNull PsiArrayAccessExpression arrayAccessExpression1, @NotNull PsiArrayAccessExpression arrayAccessExpression2) {
        if (arrayAccessExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(56);
        }
        if (arrayAccessExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(57);
        }
        PsiExpression arrayExpression2 = arrayAccessExpression1.getArrayExpression();
        PsiExpression arrayExpression1 = arrayAccessExpression2.getArrayExpression();
        PsiExpression indexExpression2 = arrayAccessExpression1.getIndexExpression();
        PsiExpression indexExpression1 = arrayAccessExpression2.getIndexExpression();
        Match arrayExpressionEq = this.expressionsMatch(arrayExpression2, arrayExpression1);
        if (arrayExpressionEq != EXACT_MATCH) {
            return EXACT_MISMATCH;
        }
        return this.expressionsMatch(indexExpression1, indexExpression2).partialIfExactMismatch((PsiElement)indexExpression1, (PsiElement)indexExpression2);
    }

    protected Match unaryExpressionsMatch(@NotNull PsiUnaryExpression unaryExpression1, @NotNull PsiUnaryExpression unaryExpression2) {
        IElementType tokenType1;
        if (unaryExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(58);
        }
        if (unaryExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(59);
        }
        if (!(tokenType1 = unaryExpression1.getOperationTokenType()).equals(unaryExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression operand1 = unaryExpression1.getOperand();
        PsiExpression operand2 = unaryExpression2.getOperand();
        return this.expressionsMatch(operand1, operand2);
    }

    protected Match polyadicExpressionsMatch(@NotNull PsiPolyadicExpression polyadicExpression1, @NotNull PsiPolyadicExpression polyadicExpression2) {
        if (polyadicExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(60);
        }
        if (polyadicExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(61);
        }
        if (!polyadicExpression1.getOperationTokenType().equals(polyadicExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        return this.expressionsAreEquivalent(polyadicExpression1.getOperands(), polyadicExpression2.getOperands(), false);
    }

    protected Match binaryExpressionsMatch(@NotNull PsiBinaryExpression binaryExpression1, @NotNull PsiBinaryExpression binaryExpression2) {
        if (binaryExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(62);
        }
        if (binaryExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(63);
        }
        IElementType tokenType1 = binaryExpression1.getOperationTokenType();
        IElementType tokenType2 = binaryExpression2.getOperationTokenType();
        PsiExpression left1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression1.getLOperand());
        PsiExpression left2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression2.getLOperand());
        PsiExpression right1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression1.getROperand());
        PsiExpression right2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression2.getROperand());
        if (right1 == null || right2 == null) {
            return Match.exact(right1 == right2);
        }
        if (!tokenType1.equals(tokenType2)) {
            RelationType rel1 = RelationType.fromElementType(tokenType1);
            RelationType rel2 = RelationType.fromElementType(tokenType2);
            if (rel1 != null && rel2 != null && rel1.getFlipped() == rel2) {
                return this.expressionsAreEquivalent(new PsiExpression[]{left1, right1}, new PsiExpression[]{right2, left2}, false);
            }
            return EXACT_MISMATCH;
        }
        return this.expressionsAreEquivalent(new PsiExpression[]{left1, right1}, new PsiExpression[]{left2, right2}, ParenthesesUtils.isCommutativeOperation((PsiPolyadicExpression)binaryExpression1));
    }

    protected Match assignmentExpressionsMatch(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
        IElementType tokenType1;
        if (assignmentExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(64);
        }
        if (assignmentExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(65);
        }
        if (!(tokenType1 = assignmentExpression1.getOperationTokenType()).equals(assignmentExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression lhs1 = assignmentExpression1.getLExpression();
        PsiExpression lhs2 = assignmentExpression2.getLExpression();
        PsiExpression rhs1 = assignmentExpression1.getRExpression();
        PsiExpression rhs2 = assignmentExpression2.getRExpression();
        Match leftEq = this.expressionsMatch(lhs1, lhs2);
        Match rightEq = this.expressionsMatch(rhs1, rhs2);
        return EquivalenceChecker.getComplexElementDecision(leftEq, rightEq, (PsiElement)lhs1, (PsiElement)lhs2, (PsiElement)rhs1, (PsiElement)rhs2);
    }

    protected Match conditionalExpressionsMatch(@NotNull PsiConditionalExpression conditionalExpression1, @NotNull PsiConditionalExpression conditionalExpression2) {
        if (conditionalExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(66);
        }
        if (conditionalExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(67);
        }
        PsiExpression condition1 = conditionalExpression1.getCondition();
        PsiExpression condition2 = conditionalExpression2.getCondition();
        PsiExpression thenExpression1 = conditionalExpression1.getThenExpression();
        PsiExpression thenExpression2 = conditionalExpression2.getThenExpression();
        PsiExpression elseExpression1 = conditionalExpression1.getElseExpression();
        PsiExpression elseExpression2 = conditionalExpression2.getElseExpression();
        if (this.expressionsMatch(condition1, condition2) == EXACT_MATCH && this.expressionsMatch(thenExpression1, thenExpression2) == EXACT_MATCH && this.expressionsMatch(elseExpression1, elseExpression2) == EXACT_MATCH) {
            return EXACT_MATCH;
        }
        return EXACT_MISMATCH;
    }

    protected Match expressionsAreEquivalent(PsiExpression @Nullable [] expressions1, PsiExpression @Nullable [] expressions2, boolean inAnyOrder) {
        if (expressions1 == null || expressions2 == null) {
            return Match.exact(expressions1 == expressions2);
        }
        if (expressions1.length != expressions2.length) {
            return EXACT_MISMATCH;
        }
        if (inAnyOrder) {
            Arrays.sort(expressions1, EXPRESSION_COMPARATOR);
            Arrays.sort(expressions2, EXPRESSION_COMPARATOR);
        }
        Match incompleteMatch = null;
        for (int i = 0; i < expressions1.length; ++i) {
            Match match = this.expressionsMatch(expressions1[i], expressions2[i]);
            if (incompleteMatch == null && match.isPartialMatch()) {
                incompleteMatch = match;
                continue;
            }
            if (match.isExactMatch()) continue;
            if (incompleteMatch != null) {
                return EXACT_MISMATCH;
            }
            incompleteMatch = match.partialIfExactMismatch((PsiElement)expressions1[i], (PsiElement)expressions2[i]);
        }
        return incompleteMatch == null ? EXACT_MATCH : incompleteMatch;
    }

    @NotNull
    private static Match getComplexElementDecision(Match equivalence1, Match equivalence2, PsiElement left1, PsiElement right1, PsiElement left2, PsiElement right2) {
        if (equivalence2 == EXACT_MATCH) {
            if (equivalence1 == EXACT_MATCH) {
                Match match = EXACT_MATCH;
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(68);
                }
                return match;
            }
            if (equivalence1 == EXACT_MISMATCH) {
                return new Match(left1, right1);
            }
            Match match = equivalence1;
            if (match == null) {
                EquivalenceChecker.$$$reportNull$$$0(69);
            }
            return match;
        }
        if (equivalence2 == EXACT_MISMATCH) {
            if (equivalence1 == EXACT_MISMATCH) {
                Match match = EXACT_MISMATCH;
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(70);
                }
                return match;
            }
            if (equivalence1 == EXACT_MATCH) {
                return new Match(left2, right2);
            }
        }
        Match match = equivalence1 == EXACT_MATCH ? equivalence2 : EXACT_MISMATCH;
        if (match == null) {
            EquivalenceChecker.$$$reportNull$$$0(71);
        }
        return match;
    }

    private static boolean modifierListsAreEquivalent(PsiModifierList modifierList1, PsiModifierList modifierList2) {
        for (String modifier : PsiModifier.MODIFIERS) {
            if ("final".equals(modifier) || modifierList1.hasModifierProperty(modifier) == modifierList2.hasModifierProperty(modifier)) continue;
            return false;
        }
        return AnnotationUtil.equal((PsiAnnotation[])modifierList1.getAnnotations(), (PsiAnnotation[])modifierList2.getAnnotations());
    }

    protected void markDeclarationsAsEquivalent(PsiElement element1, PsiElement element2) {
    }

    protected boolean equivalentDeclarations(PsiElement element1, PsiElement element2) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable2";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable1";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock2";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisExpression1";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisExpression2";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/EquivalenceChecker";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression1";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression1";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference1";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression1";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression2";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression1";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression2";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression1";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression1";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression2";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression1";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression2";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression1";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression2";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression1";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/EquivalenceChecker";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "thisExpressionsMatch";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexElementDecision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatementsMatch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "localVariablesAreEquivalent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "variablesAreEquivalent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "variableSignatureMatch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementsMatch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "conditionalLoopStatementsMatch";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forEachStatementsMatch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "switchBlocksMatch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "assertStatementsMatch";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "synchronizedStatementsMatch";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "blockStatementsMatch";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "breakStatementsMatch";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "continueStatementsMatch";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "switchLabelStatementsMatch";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "labeledStatementsMatch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementsMatch";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "expressionStatementsMatch";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "returnStatementsMatch";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "throwStatementsMatch";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "expressionListStatementsMatch";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "thisExpressionsMatch";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "methodCallExpressionsMatch";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "newExpressionsMatch";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "javaCodeReferenceElementsMatch";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "arrayInitializerExpressionsMatch";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "typeCastExpressionsMatch";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "arrayAccessExpressionsMatch";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "unaryExpressionsMatch";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "polyadicExpressionsMatch";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "binaryExpressionsMatch";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "assignmentExpressionsMatch";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "conditionalExpressionsMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Match {
        private final PsiElement myLeftDiff;
        private final PsiElement myRightDiff;
        private final Boolean myExactlyMatches;

        Match(boolean exactlyMatches) {
            this.myExactlyMatches = exactlyMatches;
            this.myLeftDiff = null;
            this.myRightDiff = null;
        }

        Match(PsiElement leftDiff, PsiElement rightDiff) {
            this.myExactlyMatches = null;
            this.myLeftDiff = leftDiff;
            this.myRightDiff = rightDiff;
        }

        public PsiElement getLeftDiff() {
            return this.myLeftDiff;
        }

        public PsiElement getRightDiff() {
            return this.myRightDiff;
        }

        public boolean isPartialMatch() {
            return this.myExactlyMatches == null;
        }

        public boolean isExactMatch() {
            return this.myExactlyMatches != null && this.myExactlyMatches != false;
        }

        public boolean isExactMismatch() {
            return this.myExactlyMatches != null && this.myExactlyMatches == false;
        }

        Match partialIfExactMismatch(PsiElement left, PsiElement right) {
            return this == EXACT_MISMATCH ? new Match(left, right) : this;
        }

        static Match exact(boolean exactMatches) {
            return exactMatches ? EXACT_MATCH : EXACT_MISMATCH;
        }

        Match combine(Match other) {
            if (other.isExactMismatch() || this.isExactMatch()) {
                return other;
            }
            if (this.isExactMismatch() || other.isExactMatch()) {
                return this;
            }
            return EXACT_MISMATCH;
        }
    }
}

