/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FinalUtils {
    private FinalUtils() {
    }

    public static boolean canBeFinal(@NotNull PsiVariable variable) {
        PsiClass scope;
        if (variable == null) {
            FinalUtils.$$$reportNull$$$0(0);
        }
        if (variable.getInitializer() != null || variable instanceof PsiParameter) {
            return !VariableAccessUtils.variableIsAssigned(variable);
        }
        if (variable instanceof PsiField && !HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction((PsiField)variable)) {
            return false;
        }
        Object object = scope = variable instanceof PsiField ? PsiUtil.getTopLevelClass((PsiElement)variable) : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (scope == null) {
            return false;
        }
        THashMap finalVarProblems = new THashMap();
        THashMap uninitializedVarProblems = new THashMap();
        PsiElementProcessor elementDoesNotViolateFinality = arg_0 -> FinalUtils.lambda$canBeFinal$0(variable, (Map)uninitializedVarProblems, (Map)finalVarProblems, arg_0);
        return PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)elementDoesNotViolateFinality);
    }

    private static /* synthetic */ boolean lambda$canBeFinal$0(PsiVariable variable, Map uninitializedVarProblems, Map finalVarProblems, PsiElement e) {
        if (!(e instanceof PsiReferenceExpression)) {
            return true;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)e;
        if (!ref.isReferenceTo((PsiElement)variable)) {
            return true;
        }
        HighlightInfo highlightInfo = HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(ref, variable, uninitializedVarProblems, variable.getContainingFile(), true);
        if (highlightInfo != null) {
            return false;
        }
        if (!PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
            return true;
        }
        if (!LocalsOrMyInstanceFieldsControlFlowPolicy.isLocalOrMyInstanceReference(ref)) {
            return false;
        }
        if (ControlFlowUtil.isVariableAssignedInLoop(ref, (PsiElement)variable)) {
            return false;
        }
        if (variable instanceof PsiField) {
            if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)ref) == null) {
                return false;
            }
            PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)ref);
            if (innerClass != null && innerClass != ((PsiField)variable).getContainingClass()) {
                return false;
            }
        }
        return HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, ref, finalVarProblems) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/FinalUtils", "canBeFinal"));
    }
}

