/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiMathUtil {
    private JavaPsiMathUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static String add(@NotNull PsiExpression expression2, int addend, @NotNull CommentTracker ct) {
        PsiPolyadicExpression polyadicExpression;
        int multiplier;
        if (expression2 == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(0);
        }
        if (ct == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(1);
        }
        if (addend == 0) {
            String string = ct.text((PsiElement)expression2);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        Number value2 = JavaPsiMathUtil.getNumberFromLiteral(stripped);
        if (value2 instanceof Integer) {
            String string = String.valueOf(value2.intValue() + addend);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (value2 instanceof Long) {
            String string = String.valueOf(value2.longValue() + (long)addend);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (stripped instanceof PsiPolyadicExpression && (multiplier = JavaPsiMathUtil.getMultiplier(polyadicExpression = (PsiPolyadicExpression)stripped)) != 0) {
            value2 = JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
            String updatedAddend = null;
            if (value2 instanceof Integer) {
                updatedAddend = String.valueOf(value2.intValue() * multiplier + addend);
            } else if (value2 instanceof Long) {
                updatedAddend = String.valueOf(value2.longValue() * (long)multiplier + (long)addend);
            }
            if (updatedAddend != null) {
                if (updatedAddend.equals("0")) {
                    updatedAddend = "";
                } else if (!updatedAddend.startsWith("-")) {
                    updatedAddend = "+" + updatedAddend;
                }
                String string = JavaPsiMathUtil.updateLastAddend(polyadicExpression, updatedAddend, ct);
                if (string == null) {
                    JavaPsiMathUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = ct.text(expression2, 6) + (addend > 0 ? "+" : "") + addend;
        if (string == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static String simplifyComparison(PsiExpression comparison, @NotNull CommentTracker ct) {
        if (ct == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(7);
        }
        if (!(comparison instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)comparison;
        RelationType relationType = RelationType.fromElementType(binOp.getOperationTokenType());
        if (relationType == null) {
            return null;
        }
        String operator2 = binOp.getOperationSign().getText();
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        Integer leftValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(left), Integer.class);
        Integer rightValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(right), Integer.class);
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)left, PsiPolyadicExpression.class);
        Integer leftAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(leftPolyadic), Integer.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)right, PsiPolyadicExpression.class);
        Integer rightAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(rightPolyadic), Integer.class);
        if (leftAddend != null) {
            if (leftAddend == 1 && operator2.equals(">")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">=" + ct.text((PsiElement)right);
            }
            if (leftAddend == 1 && operator2.equals("<=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator2.equals(">=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator2.equals("<")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<=" + ct.text((PsiElement)right);
            }
            if (rightValue != null) {
                rightValue = rightValue - leftAddend;
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + rightValue;
            }
        }
        if (rightAddend != null) {
            if (rightAddend == 1 && operator2.equals("<")) {
                return ct.text((PsiElement)left) + "<=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == 1 && operator2.equals(">=")) {
                return ct.text((PsiElement)left) + ">" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator2.equals("<=")) {
                return ct.text((PsiElement)left) + "<" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator2.equals(">")) {
                return ct.text((PsiElement)left) + ">=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (leftValue != null) {
                leftValue = leftValue - rightAddend;
                return leftValue + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
        }
        if (leftAddend != null && rightAddend != null) {
            int diff = leftAddend - rightAddend;
            if (diff > 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "+" + diff, ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (diff < 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "+" + -diff, ct);
            }
            return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
        }
        return null;
    }

    private static String updateLastAddend(PsiPolyadicExpression polyadicExpression, String updatedAddend, CommentTracker ct) {
        PsiExpression lastElement = Objects.requireNonNull((PsiExpression)ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
        PsiJavaToken lastToken = Objects.requireNonNull(polyadicExpression.getTokenBeforeOperand(lastElement));
        PsiElement from = polyadicExpression.getFirstChild();
        PsiElement to = lastToken.getPrevSibling();
        return ((StreamEx)StreamEx.iterate((Object)from, PsiElement::getNextSibling).takeWhileInclusive(e -> !to.equals(e))).map(ct::text).joining() + updatedAddend;
    }

    @Nullable
    @Contract(value="null->null")
    public static Number getNumberFromLiteral(@Nullable PsiExpression expression2) {
        PsiExpression operand2;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiLiteralExpression) {
            return (Number)ObjectUtils.tryCast((Object)((PsiLiteralExpression)expression2).getValue(), Number.class);
        }
        if (expression2 instanceof PsiUnaryExpression && ((PsiUnaryExpression)expression2).getOperationTokenType().equals(JavaTokenType.MINUS) && (operand2 = ((PsiUnaryExpression)expression2).getOperand()) instanceof PsiLiteralExpression) {
            Object value2 = ((PsiLiteralExpression)operand2).getValue();
            return JavaPsiMathUtil.negate(value2);
        }
        return null;
    }

    @Nullable
    public static Number negate(Object value2) {
        if (value2 instanceof Integer) {
            return -((Integer)value2).intValue();
        }
        if (value2 instanceof Long) {
            return -((Long)value2).longValue();
        }
        if (value2 instanceof Double) {
            return -((Double)value2).doubleValue();
        }
        if (value2 instanceof Float) {
            return Float.valueOf(-((Float)value2).floatValue());
        }
        return null;
    }

    private static int getMultiplier(PsiPolyadicExpression polyadicExpression) {
        IElementType type2 = polyadicExpression.getOperationTokenType();
        int multiplier = type2.equals(JavaTokenType.PLUS) ? 1 : (type2.equals(JavaTokenType.MINUS) ? -1 : 0);
        return multiplier;
    }

    @Nullable
    private static Number getLastAddend(PsiPolyadicExpression polyadic) {
        int multiplier;
        if (polyadic != null && (multiplier = JavaPsiMathUtil.getMultiplier(polyadic)) != 0) {
            PsiExpression lastOp = (PsiExpression)ArrayUtil.getLastElement((Object[])polyadic.getOperands());
            Number lastAddend = JavaPsiMathUtil.getNumberFromLiteral(lastOp);
            if (multiplier == 1) {
                return lastAddend;
            }
            if (multiplier == -1) {
                return JavaPsiMathUtil.negate(lastAddend);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/JavaPsiMathUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/JavaPsiMathUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "simplifyComparison";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

