/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<RefMethod> calculateSiblingMethods(RefMethod method) {
        HashSet<RefMethod> siblingMethods = new HashSet<RefMethod>();
        Stack pendingMethods = new Stack();
        pendingMethods.add((Object)method);
        while (!pendingMethods.isEmpty()) {
            RefMethod methodToAnalyze = (RefMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            Collection overridingMethods = methodToAnalyze.getDerivedMethods();
            for (RefMethod overridingMethod : overridingMethods) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains((Object)overridingMethod)) continue;
                pendingMethods.add((Object)overridingMethod);
            }
            Collection superMethods = methodToAnalyze.getSuperMethods();
            for (RefMethod superMethod : superMethods) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains((Object)superMethod)) continue;
                pendingMethods.add((Object)superMethod);
            }
        }
        return siblingMethods;
    }
}

