/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableNameGenerator {
    @NotNull
    private final JavaCodeStyleManager myManager;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final VariableKind myKind;
    private final Set<String> candidates;

    public VariableNameGenerator(@NotNull PsiElement context, @NotNull VariableKind kind2) {
        if (context == null) {
            VariableNameGenerator.$$$reportNull$$$0(0);
        }
        if (kind2 == null) {
            VariableNameGenerator.$$$reportNull$$$0(1);
        }
        this.candidates = new LinkedHashSet<String>();
        this.myManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
        this.myContext = context;
        this.myKind = kind2;
    }

    public VariableNameGenerator byType(@Nullable PsiType type2) {
        if (type2 != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, null, type2, true);
            this.candidates.addAll(Arrays.asList(info.names));
            if (type2.equals(PsiType.INT)) {
                this.candidates.add("j");
                this.candidates.add("k");
            }
        }
        return this;
    }

    public VariableNameGenerator byExpression(@Nullable PsiExpression expression2) {
        if (expression2 != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, expression2, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    public VariableNameGenerator byCollectionName(@Nullable String name2) {
        if (name2 != null) {
            PsiExpression expr2 = JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createExpressionFromText(name2 + "[0]", this.myContext);
            this.byExpression(expr2);
        }
        return this;
    }

    public VariableNameGenerator byName(String ... names2) {
        for (String name2 : names2) {
            if (name2 == null) continue;
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, name2, null, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    @NotNull
    public String generate(boolean lookForward) {
        String suffixed = null;
        for (String candidate : this.candidates.isEmpty() ? Collections.singleton("v") : this.candidates) {
            String name2 = this.myManager.suggestUniqueVariableName(candidate, this.myContext, lookForward);
            if (name2.equals(candidate)) {
                String string = name2;
                if (string == null) {
                    VariableNameGenerator.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (suffixed != null) continue;
            suffixed = name2;
        }
        String string = suffixed;
        if (string == null) {
            VariableNameGenerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<String> generateAll(boolean lookForward) {
        ArrayList<String> suffixed = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (String candidate : this.candidates.isEmpty() ? Collections.singleton("v") : this.candidates) {
            String name2 = this.myManager.suggestUniqueVariableName(candidate, this.myContext, lookForward);
            if (name2.equals(candidate)) {
                result.add(name2);
                continue;
            }
            suffixed.add(name2);
        }
        result.addAll(suffixed);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            VariableNameGenerator.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/VariableNameGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/VariableNameGenerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

