/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableReturnedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final boolean myBuilderPattern;
    private boolean returned;

    VariableReturnedVisitor(@NotNull PsiVariable variable, boolean builderPattern) {
        if (variable == null) {
            VariableReturnedVisitor.$$$reportNull$$$0(0);
        }
        this.returned = false;
        this.variable = variable;
        this.myBuilderPattern = builderPattern;
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        PsiExpression returnValue;
        if (returnStatement == null) {
            VariableReturnedVisitor.$$$reportNull$$$0(1);
        }
        if (VariableAccessUtils.mayEvaluateToVariable(returnValue = returnStatement.getReturnValue(), this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitReturnStatement(returnStatement);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiElement body2 = expression2.getBody();
        if (body2 instanceof PsiExpression && VariableAccessUtils.mayEvaluateToVariable((PsiExpression)body2, this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitLambdaExpression(expression2);
    }

    public boolean isReturned() {
        return this.returned;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableReturnedVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

