/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableObjectBoundToHttpSessionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.serializable.object.bound.to.http.session.problem.descriptor", new Object[0]);
        if (string == null) {
            NonSerializableObjectBoundToHttpSessionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableObjectBoundToHttpSessionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableObjectBoundToHttpSessionInspection", "buildErrorString"));
    }

    private static class NonSerializableObjectBoundToHttpSessionVisitor
    extends BaseInspectionVisitor {
        private NonSerializableObjectBoundToHttpSessionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            super.visitMethodCallExpression(methodCallExpression);
            if (!MethodCallUtils.isSimpleCallToMethod(methodCallExpression, "javax.servlet.http.HttpSession", (PsiType)PsiType.VOID, "putValue", "java.lang.String", "java.lang.Object") && !MethodCallUtils.isSimpleCallToMethod(methodCallExpression, "javax.servlet.http.HttpSession", (PsiType)PsiType.VOID, "setAttribute", "java.lang.String", "java.lang.Object")) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2) {
                return;
            }
            PsiExpression argument = arguments[1];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            if (SerializationUtils.isProbablySerializable(argumentType)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }
    }
}

