/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerialVersionUIDFieldInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonSerializableClassWithSerialVersionUID";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType()) {
            String string = InspectionGadgetsBundle.message("non.serializable.@interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (aClass.isInterface()) {
            String string = InspectionGadgetsBundle.message("non.serializable.interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (aClass instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.serialversionuid.problem.descriptor", new Object[0]);
        if (string == null) {
            NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        PsiClass aClass = (PsiClass)infos[0];
        PsiField field = aClass.findFieldByName("serialVersionUID", false);
        if (field == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(4);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        boolean onTheFly = (Boolean)infos[1];
        DelegatingFix removeFieldFix = new DelegatingFix((LocalQuickFix)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)field));
        if (aClass.isAnnotationType() || aClass.isInterface() || aClass instanceof PsiAnonymousClass) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray2;
            if (onTheFly) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray3 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray2 = inspectionGadgetsFixArray3;
                inspectionGadgetsFixArray3[0] = removeFieldFix;
            } else {
                inspectionGadgetsFixArray2 = InspectionGadgetsFix.EMPTY_ARRAY;
            }
            if (inspectionGadgetsFixArray2 == null) {
                NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(5);
            }
            return inspectionGadgetsFixArray2;
        }
        if (onTheFly) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray4 = new InspectionGadgetsFix[2];
            inspectionGadgetsFixArray4[0] = DelegatingFixFactory.createMakeSerializableFix(aClass);
            inspectionGadgetsFixArray = inspectionGadgetsFixArray4;
            inspectionGadgetsFixArray4[1] = removeFieldFix;
        } else {
            InspectionGadgetsFix[] inspectionGadgetsFixArray5 = new InspectionGadgetsFix[1];
            inspectionGadgetsFixArray = inspectionGadgetsFixArray5;
            inspectionGadgetsFixArray5[0] = DelegatingFixFactory.createMakeSerializableFix(aClass);
        }
        if (inspectionGadgetsFixArray == null) {
            NonSerializableWithSerialVersionUIDFieldInspection.$$$reportNull$$$0(6);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerialVersionUIDVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonSerializableWithSerialVersionUIDVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerialVersionUIDVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField field;
            if (aClass == null) {
                NonSerializableWithSerialVersionUIDVisitor.$$$reportNull$$$0(0);
            }
            if ((field = aClass.findFieldByName("serialVersionUID", false)) == null) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass, this.isOnTheFly());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$NonSerializableWithSerialVersionUIDVisitor", "visitClass"));
        }
    }
}

