/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", infos);
        if (string == null) {
            ControlFlowStatementWithoutBracesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new ControlFlowStatementFix((String)infos[0]);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection", "buildErrorString"));
    }

    private static class ControlFlowStatementVisitor
    extends ControlFlowStatementVisitorBase {
        private ControlFlowStatementVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body2) {
            PsiIfStatement ifStatement;
            PsiElement parent;
            if (body2 instanceof PsiIfStatement && this.isVisibleHighlight((PsiElement)body2) && (parent = body2.getParent()) instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getElseBranch() == body2) {
                return false;
            }
            return body2 != null && !(body2 instanceof PsiBlockStatement);
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body2) {
            if (body2 instanceof PsiLoopStatement || body2 instanceof PsiIfStatement) {
                PsiElement lastChild = body2.getLastChild();
                return Pair.create((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)body2), (Object)(PsiUtil.isJavaToken((PsiElement)lastChild, (IElementType)JavaTokenType.SEMICOLON) ? lastChild : null));
            }
            return null;
        }
    }

    private static class ControlFlowStatementFix
    extends InspectionGadgetsFix {
        private final String myKeywordText;

        ControlFlowStatementFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.message", this.myKeywordText);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement statementWithoutBraces;
            PsiStatement statement;
            PsiElement element = descriptor.getStartElement();
            PsiElement parent = element.getParent();
            if (element instanceof PsiStatement) {
                statement = (PsiStatement)element;
            } else if (parent instanceof PsiStatement) {
                statement = (PsiStatement)parent;
            } else {
                return;
            }
            if (statement instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                statementWithoutBraces = element == ifStatement.getElseElement() ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            BlockUtils.expandSingleStatementToBlockStatement(statementWithoutBraces);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

