/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class OptionalContainsCollectionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message(type2 instanceof PsiArrayType ? "optional.contains.array.problem.descriptor" : "optional.contains.collection.problem.descriptor", new Object[0]);
        if (string == null) {
            OptionalContainsCollectionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalContainsCollectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/OptionalContainsCollectionInspection", "buildErrorString"));
    }

    private static class OptionalContainsCollectionVisitor
    extends BaseInspectionVisitor {
        private OptionalContainsCollectionVisitor() {
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiType type2 = typeElement.getType();
            if (!TypeUtils.isOptional(type2)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement == null) {
                return;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
            if (typeParameterElements.length != 1) {
                return;
            }
            PsiTypeElement typeParameterElement = typeParameterElements[0];
            PsiType parameterType = typeParameterElement.getType();
            if (!(parameterType instanceof PsiArrayType) && !CollectionUtils.isCollectionClassOrInterface(parameterType)) {
                return;
            }
            this.registerError((PsiElement)typeParameterElement, parameterType);
        }
    }
}

