/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.InconvertibleTypesChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertBetweenInconvertibleTypesInspection
extends BaseInspection {
    private static final CallMatcher ASSERTJ_IS_EQUAL = CallMatcher.instanceCall("org.assertj.core.api.Assert", "isEqualTo", "isSameAs", "isNotEqualTo", "isNotSameAs").parameterTypes("java.lang.Object");
    private static final CallMatcher ASSERTJ_DESCRIBED = CallMatcher.instanceCall("org.assertj.core.api.Descriptable", "describedAs", "as");
    private static final CallMatcher ASSERTJ_ASSERT_THAT = CallMatcher.staticCall("org.assertj.core.api.Assertions", "assertThat").parameterCount(1);

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        String comparedTypeText = ((PsiType)infos[1]).getPresentableText();
        String comparisonTypeText = ((PsiType)infos[2]).getPresentableText();
        if (AssertBetweenInconvertibleTypesInspection.isAssertNotEqualsMethod(methodName)) {
            String string = InspectionGadgetsBundle.message("assertnotequals.between.inconvertible.types.problem.descriptor", comparedTypeText, comparisonTypeText);
            if (string == null) {
                AssertBetweenInconvertibleTypesInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (AssertBetweenInconvertibleTypesInspection.isAssertNotSameMethod(methodName)) {
            String string = InspectionGadgetsBundle.message("assertnotsame.between.inconvertible.types.problem.descriptor", comparedTypeText, comparisonTypeText);
            if (string == null) {
                AssertBetweenInconvertibleTypesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXmlEntities((String)comparedTypeText), StringUtil.escapeXmlEntities((String)comparisonTypeText));
        if (string == null) {
            AssertBetweenInconvertibleTypesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsBetweenInconvertibleTypesVisitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static boolean isAssertNotEqualsMethod(@NotNull String methodName) {
        if (methodName == null) {
            AssertBetweenInconvertibleTypesInspection.$$$reportNull$$$0(3);
        }
        return "assertNotEquals".equals(methodName) || "isNotEqualTo".equals(methodName);
    }

    private static boolean isAssertNotSameMethod(@NotNull String methodName) {
        if (methodName == null) {
            AssertBetweenInconvertibleTypesInspection.$$$reportNull$$$0(4);
        }
        return "assertNotSame".equals(methodName) || "isNotSameAs".equals(methodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/testFrameworks/AssertBetweenInconvertibleTypesInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/testFrameworks/AssertBetweenInconvertibleTypesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAssertNotEqualsMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAssertNotSameMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AssertEqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            this.processAssertHint(AssertHint.createAssertEqualsHint(expression2), expression2);
            this.processAssertHint(AssertHint.createAssertNotEqualsHint(expression2), expression2);
            this.processAssertHint(AssertHint.createAssertSameHint(expression2), expression2);
            this.processAssertHint(AssertHint.createAssertNotSameHint(expression2), expression2);
            this.processAssertJ(expression2);
        }

        private void processAssertJ(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(1);
            }
            if (!ASSERTJ_IS_EQUAL.test(call)) {
                return;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            while (ASSERTJ_DESCRIBED.test(qualifierCall)) {
                qualifierCall = MethodCallUtils.getQualifierMethodCall(qualifierCall);
            }
            if (!ASSERTJ_ASSERT_THAT.test(qualifierCall)) {
                return;
            }
            this.checkConvertibleTypes(call, call.getArgumentList().getExpressions()[0], qualifierCall.getArgumentList().getExpressions()[0]);
        }

        private void processAssertHint(@Nullable AssertHint assertHint, @NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(2);
            }
            if (assertHint == null) {
                return;
            }
            PsiExpression firstArgument = assertHint.getFirstArgument();
            PsiExpression secondArgument = assertHint.getSecondArgument();
            PsiParameter firstParameter = MethodCallUtils.getParameterForArgument(firstArgument);
            if (firstParameter == null || !TypeUtils.isJavaLangObject(firstParameter.getType())) {
                return;
            }
            PsiParameter secondParameter = MethodCallUtils.getParameterForArgument(secondArgument);
            if (secondParameter == null || !TypeUtils.isJavaLangObject(secondParameter.getType())) {
                return;
            }
            this.checkConvertibleTypes(expression2, firstArgument, secondArgument);
        }

        private void checkConvertibleTypes(@NotNull PsiMethodCallExpression expression2, @NotNull PsiExpression firstArgument, @NotNull PsiExpression secondArgument) {
            PsiType type1;
            if (expression2 == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(3);
            }
            if (firstArgument == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(4);
            }
            if (secondArgument == null) {
                AssertEqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(5);
            }
            if ((type1 = firstArgument.getType()) == null) {
                return;
            }
            PsiType type2 = secondArgument.getType();
            if (type2 == null) {
                return;
            }
            InconvertibleTypesChecker.LookForMutualSubclass lookForMutualSubclass = this.isOnTheFly() ? InconvertibleTypesChecker.LookForMutualSubclass.IF_CHEAP : InconvertibleTypesChecker.LookForMutualSubclass.ALWAYS;
            InconvertibleTypesChecker.TypeMismatch mismatch = InconvertibleTypesChecker.checkTypes(type1, type2, lookForMutualSubclass);
            if (mismatch != null) {
                PsiElement name2;
                String methodName = (name2 = Objects.requireNonNull(expression2.getMethodExpression().getReferenceNameElement())).getText();
                this.registerError(name2, AssertBetweenInconvertibleTypesInspection.isAssertNotEqualsMethod(methodName) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{methodName, mismatch.getLeft(), mismatch.getRight()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstArgument";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondArgument";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/testFrameworks/AssertBetweenInconvertibleTypesInspection$AssertEqualsBetweenInconvertibleTypesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAssertJ";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAssertHint";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConvertibleTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

