/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAtomicOperationOnVolatileFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            NonAtomicOperationOnVolatileFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonAtomicOperationOnVolatileFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "buildErrorString"));
    }

    private static class NonAtomicOperationOnVolatileFieldVisitor
    extends BaseInspectionVisitor {
        private NonAtomicOperationOnVolatileFieldVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                NonAtomicOperationOnVolatileFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getRExpression());
            if (rhs == null) {
                return;
            }
            final PsiExpression lhs = expression2.getLExpression();
            PsiReferenceExpression volatileFieldRef = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileFieldRef(lhs);
            if (volatileFieldRef == null) {
                return;
            }
            final PsiElement referenceNameElement2 = volatileFieldRef.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) || tokenType.equals(JavaTokenType.MINUSEQ) || tokenType.equals(JavaTokenType.ASTERISKEQ) || tokenType.equals(JavaTokenType.DIVEQ) || tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ) || tokenType.equals(JavaTokenType.XOREQ) || tokenType.equals(JavaTokenType.PERCEQ) || tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ)) {
                this.registerError(referenceNameElement2, new Object[0]);
                return;
            }
            rhs.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression reference) {
                    if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, (PsiExpression)reference)) {
                        this.stopWalking();
                        this.registerError(referenceNameElement2, new Object[0]);
                        return;
                    }
                    super.visitReferenceExpression(reference);
                }
            });
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            if (!PsiUtil.isIncrementDecrementOperation((PsiElement)expression2)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiReferenceExpression volatileFieldRef = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileFieldRef(operand2);
            if (volatileFieldRef == null) {
                return;
            }
            PsiElement referenceNameElement2 = volatileFieldRef.getReferenceNameElement();
            if (referenceNameElement2 != null) {
                this.registerError(referenceNameElement2, new Object[0]);
            }
        }

        @Nullable
        private static PsiReferenceExpression findNonSynchronizedVolatileFieldRef(PsiExpression expression2) {
            if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("volatile")) {
                return null;
            }
            if (SynchronizationUtil.isInSynchronizedContext((PsiElement)reference)) {
                return null;
            }
            return (PsiReferenceExpression)expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor", "visitAssignmentExpression"));
        }
    }
}

