/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnStaticFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("synchronization.on.static.field.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizationOnStaticFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnStaticFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnStaticFieldInspection", "buildErrorString"));
    }

    private static class SynchronizationOnStaticFieldVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnStaticFieldVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression2 = statement.getLockExpression();
            if (!(lockExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression expression2 = (PsiReferenceExpression)lockExpression2;
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)lockExpression2, new Object[0]);
        }
    }
}

