/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassVariableHidesOuterClassVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "InnerClassFieldHidesOuterClassField";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.field.hides.outer.problem.descriptor", new Object[0]);
        if (string == null) {
            InnerClassVariableHidesOuterClassVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.field.hides.outer.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassVariableHidesOuterClassVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection", "buildErrorString"));
    }

    private class InnerClassVariableHidesOuterClassVariableVisitor
    extends BaseInspectionVisitor {
        private InnerClassVariableHidesOuterClassVariableVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass aClass;
            if (field == null) {
                InnerClassVariableHidesOuterClassVariableVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            PsiClass ancestorClass = ClassUtils.getContainingClass((PsiElement)aClass);
            while (ancestorClass != null) {
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (!(ancestorField == null || InnerClassVariableHidesOuterClassVariableInspection.this.m_ignoreInvisibleFields && !ancestorField.hasModifierProperty("static") && RefactoringUtil.isInStaticContext((PsiElement)aClass, ancestorClass))) {
                    this.registerFieldError(field, new Object[0]);
                }
                aClass = ancestorClass;
                ancestorClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection$InnerClassVariableHidesOuterClassVariableVisitor", "visitField"));
        }
    }
}

