/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "LambdaParameterHidesMemberVariable";
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            LambdaParameterHidingMemberVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.ignore.invisible.option", new Object[0]), "m_ignoreInvisibleFields");
        return optionsPanel;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaParameterHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspection", "buildErrorString"));
    }

    private class LambdaParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LambdaParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                LambdaParameterHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiLambdaExpression)) {
                return;
            }
            PsiClass aClass = this.checkFieldName((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable) {
            String variableName2 = variable.getName();
            if (variableName2 == null) {
                return null;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            while (aClass != null) {
                PsiField field = aClass.findFieldByName(variableName2, true);
                if (field != null) {
                    if (!LambdaParameterHidingMemberVariableInspection.this.m_ignoreInvisibleFields) {
                        return aClass;
                    }
                    if (ClassUtils.isFieldVisible(field, aClass) && PsiUtil.getEnclosingStaticElement((PsiElement)variable, (PsiClass)aClass) == null || field.hasModifierProperty("static")) {
                        return aClass;
                    }
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspection$LambdaParameterHidingMemberVariableVisitor", "visitParameter"));
        }
    }
}

