/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodOverridesStaticMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection", "buildErrorString"));
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] methods;
            PsiClass aClass;
            if (method == null) {
                MethodOverridesStaticMethodVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = method.getContainingClass()) == null) {
                return;
            }
            if (method.getNameIdentifier() == null || !method.hasModifierProperty("static")) {
                return;
            }
            PsiClass ancestorClass = aClass.getSuperClass();
            if (ancestorClass == null) {
                return;
            }
            for (PsiMethod testMethod : methods = ancestorClass.findMethodsBySignature(method, true)) {
                if (!testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection$MethodOverridesStaticMethodVisitor", "visitMethod"));
        }
    }
}

