/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.EndOfLineCommentPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeToCStyleCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new EndOfLineCommentPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String newCommentString;
        CharSequence text2;
        PsiElement prevComment;
        if (element == null) {
            ChangeToCStyleCommentIntention.$$$reportNull$$$0(0);
        }
        PsiComment firstComment = (PsiComment)element;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstComment))) {
            firstComment = (PsiComment)prevComment;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        ArrayList<PsiComment> multiLineComments = new ArrayList<PsiComment>();
        PsiComment nextComment = firstComment;
        String whiteSpace = null;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextComment)))) {
            if (whiteSpace == null) {
                PsiElement prevSibling = nextComment.getPrevSibling();
                assert (prevSibling != null);
                text2 = prevSibling.getText();
                whiteSpace = ChangeToCStyleCommentIntention.getIndent((String)text2);
            }
            multiLineComments.add(nextComment);
        }
        if (multiLineComments.isEmpty()) {
            String text22 = ChangeToCStyleCommentIntention.getCommentContents(firstComment);
            newCommentString = "/* " + text22.trim() + " */";
        } else {
            text2 = new StringBuilder();
            ((StringBuilder)text2).append("/*\n");
            ((StringBuilder)text2).append(whiteSpace);
            ((StringBuilder)text2).append(ChangeToCStyleCommentIntention.getCommentContents(firstComment));
            for (PsiComment psiComment : multiLineComments) {
                ((StringBuilder)text2).append('\n');
                ((StringBuilder)text2).append(whiteSpace);
                ((StringBuilder)text2).append(ChangeToCStyleCommentIntention.getCommentContents(psiComment));
            }
            ((StringBuilder)text2).append('\n');
            ((StringBuilder)text2).append(whiteSpace);
            ((StringBuilder)text2).append("*/");
            newCommentString = ((StringBuilder)text2).toString();
        }
        PsiComment newComment = factory.createCommentFromText(newCommentString, element);
        firstComment.replace((PsiElement)newComment);
        for (PsiElement psiElement : multiLineComments) {
            psiElement.delete();
        }
    }

    private static String getIndent(String whitespace) {
        for (int i = whitespace.length() - 1; i >= 0; --i) {
            char c = whitespace.charAt(i);
            if (c != '\n') continue;
            if (i == whitespace.length() - 1) {
                return "";
            }
            return whitespace.substring(i + 1);
        }
        return whitespace;
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(@NotNull PsiComment comment) {
        if (comment == null) {
            ChangeToCStyleCommentIntention.$$$reportNull$$$0(1);
        }
        String text2 = comment.getText();
        return StringUtil.replace((String)text2.substring(2), (String)"*/", (String)"* /");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/comment/ChangeToCStyleCommentIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentContents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

