/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiLiteralUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.StringConcatPredicate;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JoinConcatenatedStringLiteralsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new StringConcatPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            JoinConcatenatedStringLiteralsIntention.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        StringBuilder newExpression = new StringBuilder();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        for (int i = 0; i < operands2.length; ++i) {
            PsiElement nextSibling;
            PsiExpression operand2 = operands2[i];
            if (polyadicExpression.getTokenBeforeOperand(operand2) != token) continue;
            PsiExpression prev = operands2[i - 1];
            for (nextSibling = polyadicExpression.getFirstChild(); nextSibling != prev; nextSibling = nextSibling.getNextSibling()) {
                newExpression.append(tracker.text(nextSibling));
            }
            JoinConcatenatedStringLiteralsIntention.merge((PsiLiteralExpression)prev, (PsiLiteralExpression)operand2, newExpression);
            for (nextSibling = operand2.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                newExpression.append(tracker.text(nextSibling));
            }
            break;
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), tracker);
    }

    private static void merge(PsiLiteralExpression left, PsiLiteralExpression right, StringBuilder newExpression) {
        String leftText = JoinConcatenatedStringLiteralsIntention.getLiteralExpressionText(left);
        String rightText = JoinConcatenatedStringLiteralsIntention.getLiteralExpressionText(right);
        if (left.isTextBlock()) {
            newExpression.append("\"\"\"\n").append(leftText).append(right.isTextBlock() ? rightText : PsiLiteralUtil.escapeTextBlockCharacters((String)rightText)).append("\"\"\"");
        } else if (right.isTextBlock()) {
            newExpression.append("\"\"\"\n").append(PsiLiteralUtil.escapeTextBlockCharacters((String)leftText)).append(rightText).append("\"\"\"");
        } else {
            newExpression.append('\"').append(leftText).append(rightText).append('\"');
        }
    }

    private static String getLiteralExpressionText(PsiLiteralExpression expression2) {
        PsiType type2 = expression2.getType();
        if (PsiType.CHAR.equals((Object)type2)) {
            String result = StringUtil.unquoteString((String)expression2.getText());
            if (result.equals("\"")) {
                return "\\\"";
            }
            if (result.equals("\\'")) {
                return "'";
            }
            return result;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return Objects.requireNonNull(expression2.getValue()).toString();
        }
        if (expression2.isTextBlock()) {
            return PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)expression2);
        }
        return PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/concatenation/JoinConcatenatedStringLiteralsIntention", "processIntention"));
    }
}

