/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import com.siyeh.ipp.expression.eliminate.EliminateUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AssociativeExpression
extends EliminableExpression {
    private static final Map<IElementType, IElementType[]> OUTER_OPERATORS = new HashMap<IElementType, IElementType[]>();

    @Contract(pure=true)
    AssociativeExpression(@Nullable PsiPolyadicExpression expression2, @NotNull PsiExpression operand2) {
        if (operand2 == null) {
            AssociativeExpression.$$$reportNull$$$0(0);
        }
        super(expression2, operand2);
    }

    @Override
    boolean eliminate(@Nullable PsiJavaToken tokenBefore, @NotNull StringBuilder sb) {
        IElementType tokenBeforeExpressionType;
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(1);
        }
        IElementType iElementType = tokenBeforeExpressionType = tokenBefore == null ? null : tokenBefore.getTokenType();
        if (this.myExpression == null) {
            return this.eliminateInnerExpression(this.myOperand, tokenBeforeExpressionType, sb);
        }
        if (EliminateUtils.isMultiplicative(this.myExpression.getOperationTokenType())) {
            return this.eliminateMultiplicativeExpression(this.myExpression, tokenBeforeExpressionType, EliminateUtils.isNegated((PsiExpression)this.myExpression, false, this.myOperand), sb);
        }
        if (tokenBefore != null) {
            sb.append(tokenBefore.getText());
        }
        return this.eliminateExpression(this.myExpression, null, false, sb);
    }

    private boolean eliminateInnerExpression(@NotNull PsiExpression operand2, @Nullable IElementType tokenBefore, @NotNull StringBuilder sb) {
        if (operand2 == null) {
            AssociativeExpression.$$$reportNull$$$0(2);
        }
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(3);
        }
        return EliminateUtils.processPrefixed(operand2, false, (op, isOpNegated) -> this.eliminateParenthesized((PsiParenthesizedExpression)ObjectUtils.tryCast((Object)op, PsiParenthesizedExpression.class), tokenBefore, (boolean)isOpNegated, sb));
    }

    @Contract(value="null, _, _, _ -> false")
    private boolean eliminateParenthesized(@Nullable PsiParenthesizedExpression parenthesized, @Nullable IElementType tokenBefore, boolean isNegated, @NotNull StringBuilder sb) {
        PsiPolyadicExpression expression2;
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(4);
        }
        if ((expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized), PsiPolyadicExpression.class)) == null) {
            return false;
        }
        return this.eliminateExpression(expression2, tokenBefore, isNegated, sb);
    }

    private boolean eliminateExpression(@NotNull PsiPolyadicExpression expression2, @Nullable IElementType tokenBefore, boolean isNegated, @NotNull StringBuilder sb) {
        if (expression2 == null) {
            AssociativeExpression.$$$reportNull$$$0(5);
        }
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(6);
        }
        if (EliminateUtils.isMultiplicative(expression2.getOperationTokenType())) {
            return this.eliminateMultiplicativeExpression(expression2, tokenBefore, EliminateUtils.isNegated((PsiExpression)expression2, isNegated, new PsiExpression[0]), sb);
        }
        for (PsiExpression operand2 : expression2.getOperands()) {
            IElementType tokenType = EliminateUtils.getOperandTokenType(expression2, operand2, tokenBefore);
            if (!(operand2 != this.myOperand ? EliminateUtils.processPrefixed(operand2, isNegated, (op, isOpNegated) -> this.eliminateOperand((PsiExpression)op, tokenType, (boolean)isOpNegated, sb)) == false : !this.eliminateInnerExpression(operand2, tokenType, sb))) continue;
            return false;
        }
        return true;
    }

    private boolean eliminateMultiplicativeExpression(@NotNull PsiPolyadicExpression expression2, @Nullable IElementType tokenBefore, boolean isNegated, @NotNull StringBuilder sb) {
        if (expression2 == null) {
            AssociativeExpression.$$$reportNull$$$0(7);
        }
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(8);
        }
        PsiExpression[] operands2 = expression2.getOperands();
        for (int i = 0; i < operands2.length; ++i) {
            boolean isOperandNegated;
            PsiExpression operand2 = operands2[i];
            IElementType tokenType = EliminateUtils.getOperandTokenType(expression2, operand2, tokenBefore);
            boolean bl = isOperandNegated = i == 0 && isNegated;
            if (operand2 == this.myOperand && (operand2 = (PsiExpression)EliminateUtils.processPrefixed(operand2, false, (op, isOpNegated) -> (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)op), PsiPolyadicExpression.class))) == null) {
                return false;
            }
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2, PsiPolyadicExpression.class);
            if (!(polyadic != null && EliminateUtils.isMultiplicative(polyadic.getOperationTokenType()) ? !this.eliminateMultiplicativeExpression(polyadic, tokenType, isOperandNegated, sb) : EliminateUtils.processPrefixed(operand2, false, (op, isOpNegated) -> this.eliminateOperand((PsiExpression)op, tokenType, isOperandNegated, sb)) == false)) continue;
            return false;
        }
        return true;
    }

    private boolean eliminateOperand(@NotNull PsiExpression operand2, @Nullable IElementType tokenType, boolean isNegated, @NotNull StringBuilder sb) {
        PsiPolyadicExpression polyadic;
        if (operand2 == null) {
            AssociativeExpression.$$$reportNull$$$0(9);
        }
        if (sb == null) {
            AssociativeExpression.$$$reportNull$$$0(10);
        }
        if ((polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2, PsiPolyadicExpression.class)) != null) {
            return this.eliminateExpression(polyadic, tokenType, isNegated, sb);
        }
        if (!EliminateUtils.addPrefix(tokenType, isNegated, sb)) {
            return false;
        }
        sb.append(operand2.getText());
        return true;
    }

    @Nullable
    static AssociativeExpression create(@NotNull PsiParenthesizedExpression parenthesized) {
        if (parenthesized == null) {
            AssociativeExpression.$$$reportNull$$$0(11);
        }
        return EliminateUtils.createExpression(parenthesized, AssociativeExpression::new, OUTER_OPERATORS);
    }

    static {
        OUTER_OPERATORS.put(JavaTokenType.PLUS, new IElementType[]{JavaTokenType.MINUS});
        OUTER_OPERATORS.put(JavaTokenType.MINUS, new IElementType[]{JavaTokenType.MINUS});
        OUTER_OPERATORS.put(JavaTokenType.DIV, new IElementType[]{JavaTokenType.ASTERISK, JavaTokenType.DIV});
        OUTER_OPERATORS.put(JavaTokenType.ASTERISK, new IElementType[]{JavaTokenType.DIV});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/expression/eliminate/AssociativeExpression";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateInnerExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateParenthesized";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateMultiplicativeExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateOperand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

