/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNumberConverters {
    static final NumberConverter INTEGER_TO_HEX = new NumberConverter(){

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            if (text2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (number == null) {
                1.$$$reportNull$$$0(1);
            }
            if (text2.startsWith("0x") || text2.startsWith("0X")) {
                return null;
            }
            if (number instanceof Integer) {
                return "0x" + Integer.toHexString(number.intValue());
            }
            if (number instanceof Long) {
                return "0x" + Long.toHexString(number.longValue()) + "L";
            }
            return null;
        }

        public String toString() {
            return "hex";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$1";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter INTEGER_TO_BINARY = new NumberConverter(){

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            if (text2 == null) {
                2.$$$reportNull$$$0(0);
            }
            if (number == null) {
                2.$$$reportNull$$$0(1);
            }
            if (text2.startsWith("0b") || text2.startsWith("0B")) {
                return null;
            }
            if (number instanceof Integer) {
                return "0b" + Integer.toBinaryString(number.intValue());
            }
            if (number instanceof Long) {
                return "0b" + Long.toBinaryString(number.longValue()) + "L";
            }
            return null;
        }

        public String toString() {
            return "binary";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$2";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter INTEGER_TO_OCTAL = new NumberConverter(){

        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            if (text2 == null) {
                3.$$$reportNull$$$0(0);
            }
            if (number == null) {
                3.$$$reportNull$$$0(1);
            }
            if (ExpressionUtils.isOctalLiteralText(text2)) {
                return null;
            }
            if (number instanceof Integer) {
                return "0" + Integer.toOctalString(number.intValue());
            }
            if (number instanceof Long) {
                return "0" + Long.toOctalString(number.longValue()) + "L";
            }
            return null;
        }

        public String toString() {
            return "octal";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$3";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter INTEGER_TO_DECIMAL = new NumberConverter(){

        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            if (text2 == null) {
                4.$$$reportNull$$$0(0);
            }
            if (number == null) {
                4.$$$reportNull$$$0(1);
            }
            if ("0L".equals(text2) || "0l".equals(text2) || text2.charAt(0) != '0') {
                return null;
            }
            if (number instanceof Integer) {
                return Integer.toString(number.intValue());
            }
            if (number instanceof Long) {
                return Long.toString(number.longValue()) + 'L';
            }
            return null;
        }

        public String toString() {
            return "decimal";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$4";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter FLOAT_TO_HEX = new NumberConverter(){

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String originalText, @NotNull Number original) {
            if (originalText == null) {
                5.$$$reportNull$$$0(0);
            }
            if (original == null) {
                5.$$$reportNull$$$0(1);
            }
            if (originalText.startsWith("0x") || originalText.startsWith("0X")) {
                return null;
            }
            if (original instanceof Float) {
                return Float.toHexString(original.floatValue()) + "f";
            }
            if (original instanceof Double) {
                return Double.toHexString(original.doubleValue());
            }
            return null;
        }

        public String toString() {
            return "hex";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "original";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$5";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter FLOAT_TO_DECIMAL = new NumberConverter(){

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String originalText, @NotNull Number original) {
            if (originalText == null) {
                6.$$$reportNull$$$0(0);
            }
            if (original == null) {
                6.$$$reportNull$$$0(1);
            }
            if (!originalText.startsWith("0x") && !originalText.startsWith("0X")) {
                return null;
            }
            if (original instanceof Float) {
                return Float.toString(original.floatValue()) + 'f';
            }
            if (original instanceof Double) {
                return Double.toString(original.doubleValue());
            }
            return null;
        }

        public String toString() {
            return "decimal";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "original";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$6";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter FLOAT_TO_PLAIN = new NumberConverter(){

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            String result;
            if (text2 == null) {
                7.$$$reportNull$$$0(0);
            }
            if (number == null) {
                7.$$$reportNull$$$0(1);
            }
            if (!(number instanceof Float) && !(number instanceof Double)) {
                return null;
            }
            if (!text2.contains("e") && !text2.contains("E")) {
                return null;
            }
            try {
                result = new BigDecimal(number.toString()).stripTrailingZeros().toPlainString();
            }
            catch (NumberFormatException ignored) {
                return null;
            }
            if (number instanceof Float) {
                result = result + "f";
            } else if (!result.contains(".")) {
                try {
                    Integer.parseInt(result);
                }
                catch (NumberFormatException e) {
                    return result + ".0";
                }
            }
            return result;
        }

        public String toString() {
            return "plain format";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$7";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final NumberConverter FLOAT_TO_SCIENTIFIC = new NumberConverter(){
        private final DecimalFormat FORMAT = new DecimalFormat("0.0#############E00", new DecimalFormatSymbols(Locale.US));

        @Contract(pure=true)
        @Nullable
        public String getConvertedText(@NotNull String text2, @NotNull Number number) {
            if (text2 == null) {
                8.$$$reportNull$$$0(0);
            }
            if (number == null) {
                8.$$$reportNull$$$0(1);
            }
            if (!(number instanceof Float) && !(number instanceof Double)) {
                return null;
            }
            if (text2.contains("e") || text2.contains("E")) {
                return null;
            }
            String result = this.FORMAT.format(Double.parseDouble(number.toString()));
            if (number instanceof Float) {
                result = result + "f";
            }
            return result;
        }

        public String toString() {
            return "scientific format";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/integer/JavaNumberConverters$8";
            objectArray[2] = "getConvertedText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
}

