/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import org.jetbrains.annotations.NotNull;

public class DataPointHolderConversionIntention
extends PsiElementBaseIntentionAction {
    private static final String THEORIES_PACKAGE = "org.junit.experimental.theories";
    private static final String DATA_POINT_FQN = "org.junit.experimental.theories.DataPoint";
    private static final String DATA_POINTS_FQN = "org.junit.experimental.theories.DataPoints";
    private static final String REPLACE_BY_TEMPLATE = "Replace by @%s %s";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement holder;
        if (project == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(1);
        }
        PsiMethod createdElement = (holder = element.getParent()) instanceof PsiField ? DataPointHolderConversionIntention.convertToMethod((PsiField)holder) : DataPointHolderConversionIntention.convertToField((PsiMethod)holder);
        PsiModifierListOwner oldElement = (PsiModifierListOwner)holder;
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)oldElement, (String[])new String[]{DATA_POINT_FQN, DATA_POINTS_FQN});
        assert (psiAnnotation != null);
        String annotation = psiAnnotation.getQualifiedName();
        assert (annotation != null);
        PsiModifierList modifierList = createdElement.getModifierList();
        assert (modifierList != null);
        modifierList.addAnnotation(annotation);
        modifierList.setModifierProperty("static", true);
        modifierList.setModifierProperty("public", true);
        createdElement = (PsiModifierListOwner)oldElement.replace((PsiElement)createdElement);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)createdElement);
        PsiNameIdentifierOwner asNameIdOwner = (PsiNameIdentifierOwner)createdElement;
        templateBuilder.replaceElement(asNameIdOwner.getNameIdentifier(), asNameIdOwner.getName());
        templateBuilder.run(editor, false);
    }

    private static PsiField convertToField(PsiMethod method) {
        Project project = method.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String fieldName = codeStyleManager.propertyNameToVariableName(method.getName(), VariableKind.STATIC_FIELD);
        PsiType returnType = method.getReturnType();
        assert (returnType != null);
        PsiField field = elementFactory.createField(fieldName, returnType);
        PsiStatement returnStatement = (PsiStatement)PsiTreeUtil.findChildOfType((PsiElement)method, PsiStatement.class);
        if (returnStatement != null) {
            field.setInitializer(((PsiReturnStatement)returnStatement).getReturnValue());
        }
        return field;
    }

    private static PsiMethod convertToMethod(PsiField field) {
        Project project = field.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiExpression fieldInitializer = field.getInitializer();
        PsiMethod method = elementFactory.createMethod(codeStyleManager.variableNameToPropertyName(field.getName(), VariableKind.STATIC_FIELD), field.getType());
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        PsiStatement methodCode = elementFactory.createStatementFromText("return " + fieldInitializer.getText() + ";", null);
        body2.add((PsiElement)methodCode);
        return method;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Pair<PsiMember, PsiAnnotation> dataPointsHolder;
        if (project == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(3);
        }
        if ((dataPointsHolder = DataPointHolderConversionIntention.extractDataPointsHolder(element)) != null && DataPointHolderConversionIntention.isConvertible((PsiMember)dataPointsHolder.getFirst())) {
            String replaceType = dataPointsHolder.getFirst() instanceof PsiMethod ? "field" : "method";
            String annotation = StringUtil.getShortName((String)((PsiAnnotation)dataPointsHolder.getSecond()).getQualifiedName());
            this.setText(String.format(REPLACE_BY_TEMPLATE, annotation, replaceType));
            return true;
        }
        return false;
    }

    private static Pair<PsiMember, PsiAnnotation> extractDataPointsHolder(@NotNull PsiElement element) {
        if (element == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement maybeHolder = element.getParent();
        if (!(maybeHolder instanceof PsiMethod) && !(maybeHolder instanceof PsiField)) {
            return null;
        }
        PsiMember holder = (PsiMember)maybeHolder;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)holder, (String[])new String[]{DATA_POINT_FQN, DATA_POINTS_FQN});
        return annotation == null ? null : Pair.create((Object)holder, (Object)annotation);
    }

    private static boolean isConvertible(@NotNull PsiMember member) {
        if (member == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(5);
        }
        if (!(member instanceof PsiMethod)) {
            return ((PsiField)member).getInitializer() != null;
        }
        PsiMethod method = (PsiMethod)member;
        PsiType returnType = method.getReturnType();
        if (returnType == null || returnType.equals(PsiType.VOID) || !method.getParameterList().isEmpty()) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return false;
        }
        PsiStatement[] methodStatements = body2.getStatements();
        switch (methodStatements.length) {
            case 1: {
                PsiStatement methodStatement = methodStatements[0];
                return methodStatement instanceof PsiReturnStatement;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.message("convert.datapoints.fix.family.name", new Object[0]);
        if (string == null) {
            DataPointHolderConversionIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/junit/DataPointHolderConversionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/junit/DataPointHolderConversionIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractDataPointsHolder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConvertible";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

