/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplaceAssignmentWithPostfixExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentWithPostfixExpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ReplaceAssignmentWithPostfixExpressionPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiBinaryExpression rhs = (PsiBinaryExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        IElementType tokenType = rhs == null ? null : rhs.getOperationTokenType();
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", JavaTokenType.MINUS.equals(tokenType) ? "--" : "++"});
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ReplaceAssignmentWithPostfixExpressionIntention.$$$reportNull$$$0(0);
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiExpression lhs = assignmentExpression.getLExpression();
        CommentTracker commentTracker = new CommentTracker();
        String lhsText = commentTracker.text((PsiElement)lhs);
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        if (!(rhs instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (JavaTokenType.PLUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, lhsText + "++", commentTracker);
        } else if (JavaTokenType.MINUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, lhsText + "--", commentTracker);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/opassign/ReplaceAssignmentWithPostfixExpressionIntention", "processIntention"));
    }
}

