/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class MergeElseIfPredicate
implements PsiElementPredicate {
    MergeElseIfPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        String text2 = element.getText();
        if (!"else".equals(text2)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (thenBranch == null) {
            return false;
        }
        if (!(elseBranch instanceof PsiBlockStatement)) {
            return false;
        }
        PsiCodeBlock block = ((PsiBlockStatement)elseBranch).getCodeBlock();
        PsiStatement[] statements = block.getStatements();
        return statements.length == 1 && statements[0] instanceof PsiIfStatement;
    }
}

