/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

final class HeaderAnnotator
implements Annotator {
    HeaderAnnotator() {
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            HeaderAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HeaderAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof Header) {
            Header header = (Header)psiElement;
            String name2 = header.getName();
            if (!HeaderAnnotator.isValidName(name2)) {
                holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.name.invalid", new Object[0])).range((PsiElement)header.getNameElement()).create();
            } else {
                HeaderParser headerParser = HeaderParserRepository.getInstance().getHeaderParser(name2);
                if (headerParser != null) {
                    headerParser.annotate(header, holder);
                }
            }
        }
    }

    private static boolean isValidName(String name2) {
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '-' || c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

