/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaPrefixReference
extends PsiReferenceBase<XmlElement>
implements PossiblePrefixReference,
ResolvingHint {
    private final SchemaPrefix myPrefix;
    private final String myName;
    @Nullable
    private final TagNameReference myTagNameReference;

    public SchemaPrefixReference(XmlElement element, TextRange range, String name, @Nullable TagNameReference reference) {
        super((PsiElement)element, range);
        this.myName = name;
        this.myTagNameReference = reference;
        this.myPrefix = this.myElement instanceof XmlAttribute && ((XmlAttribute)this.myElement).isNamespaceDeclaration() ? new SchemaPrefix((XmlAttribute)this.myElement, this.getRangeInElement(), this.myName) : (this.myElement instanceof XmlAttributeValue && ((XmlAttribute)((XmlElement)this.myElement).getParent()).getLocalName().equals("prefix") ? SchemaPrefix.createJspPrefix((XmlAttributeValue)this.myElement, this.myName) : null);
    }

    public String getNamespacePrefix() {
        return this.myName;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(XmlElement.class, elementClass);
    }

    public SchemaPrefix resolve() {
        return this.myPrefix == null ? SchemaPrefixReference.resolvePrefix(this.myElement, this.myName) : this.myPrefix;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            SchemaPrefixReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof SchemaPrefix) || !this.myName.equals(((SchemaPrefix)element).getName())) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            SchemaPrefixReference.$$$reportNull$$$0(1);
        }
        if (this.myElement instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)this.myElement;
            return "xmlns".equals(attr.getNamespacePrefix()) ? attr.setName(attr.getNamespacePrefix() + ":" + name) : attr.setName(name + ":" + attr.getLocalName());
        }
        if (this.myElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)this.myElement;
            return tag.setName(name + ":" + tag.getLocalName());
        }
        return super.handleElementRename(name);
    }

    @Nullable
    public static SchemaPrefix resolvePrefix(PsiElement element, String name) {
        XmlExtension extension = XmlExtension.getExtension(element.getContainingFile());
        return extension.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false), name);
    }

    public boolean isSoft() {
        return true;
    }

    @Override
    public boolean isPrefixReference() {
        return true;
    }

    @Nullable
    public TagNameReference getTagNameReference() {
        return this.myTagNameReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/xml/SchemaPrefixReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleElementRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

