/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.language.Language;
import org.languagetool.language.Languages;
import org.languagetool.noop.NoopLanguage;
import org.languagetool.tools.MultiKeyProperties;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00040 j\b\u0012\u0004\u0012\u00020\u0004`!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\bJ\u001e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\b2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bJ\u0012\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\bH\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006*"}, d2={"Lorg/languagetool/language/Languages;", "", "()V", "NOOP_LANGUAGE", "Lorg/languagetool/language/Language;", "getNOOP_LANGUAGE", "()Lorg/languagetool/language/Language;", "PROPERTIES_KEY", "", "PROPERTIES_PATH", "allLanguages", "", "getAllLanguages", "()Ljava/util/List;", "dynLanguages", "", "languages", "getLanguages", "languages$delegate", "Lkotlin/Lazy;", "staticAndDynamicLanguages", "getStaticAndDynamicLanguages", "withDemoLanguage", "getWithDemoLanguage", "add", "", "lang", "createLanguageObjects", "url", "Ljava/net/URL;", "className", "get", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getLanguageForName", "languageName", "getLanguageForShortCode", "langCode", "noopLanguageCodes", "getLanguageForShortCodeOrNull", "isLanguageSupported", "", "languagetool-core"})
public final class Languages {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String PROPERTIES_PATH = "META-INF/org/languagetool/language-module.properties";
    private static final String PROPERTIES_KEY = "languageClasses";
    @NotNull
    private static final Language NOOP_LANGUAGE;
    private static final Lazy languages$delegate;
    private static final List<Language> dynLanguages;
    public static final Languages INSTANCE;

    static {
        Languages languages2;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Languages.class), "languages", "getLanguages()Ljava/util/List;"))};
        INSTANCE = languages2 = new Languages();
        NOOP_LANGUAGE = new NoopLanguage();
        languages$delegate = LazyKt.lazy((Function0)languages.2.INSTANCE);
        dynLanguages = new ArrayList();
    }

    @NotNull
    public final Language getNOOP_LANGUAGE() {
        return NOOP_LANGUAGE;
    }

    private final List<Language> getLanguages() {
        Lazy lazy = languages$delegate;
        Languages languages2 = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final void add(@NotNull Language lang) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        if (!dynLanguages.contains(lang)) {
            dynLanguages.add(lang);
        }
    }

    @NotNull
    public final ArrayList<Language> get() {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Language> $this$apply = arrayList;
        boolean bl3 = false;
        for (Language lang : INSTANCE.getStaticAndDynamicLanguages()) {
            if (!(Intrinsics.areEqual((Object)"xx", (Object)lang.getShortCode()) ^ true) || !(Intrinsics.areEqual((Object)"zz", (Object)lang.getShortCode()) ^ true)) continue;
            $this$apply.add(lang);
        }
        return arrayList;
    }

    @NotNull
    public final List<Language> getWithDemoLanguage() {
        List<Language> list = Collections.unmodifiableList(this.getStaticAndDynamicLanguages());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiable\u2026taticAndDynamicLanguages)");
        return list;
    }

    private final List<Language> getStaticAndDynamicLanguages() {
        return CollectionsKt.plus((Collection)this.getLanguages(), (Iterable)dynLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Language> getAllLanguages() {
        List languages2 = new ArrayList();
        Set languageClassNames = new HashSet();
        Enumeration<URL> enumeration = Language.class.getClassLoader().getResources(PROPERTIES_PATH);
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"Language::class.java.cla\u2026esources(PROPERTIES_PATH)");
        Enumeration<URL> enumeration2 = enumeration;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URL url = (URL)element$iv;
            boolean bl2 = false;
            Closeable closeable = url.openStream();
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl4 = false;
                InputStream inputStream2 = inputStream;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
                MultiKeyProperties props = new MultiKeyProperties(inputStream2);
                List<String> list = props.getProperty(PROPERTIES_KEY);
                if (list == null) {
                    throw (Throwable)new RuntimeException("Key 'languageClasses' not found in " + url);
                }
                for (String classNames : list) {
                    String[] stringArray;
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)classNames, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    for (String className : stringArray) {
                        if (languageClassNames.contains(className)) continue;
                        URL uRL = url;
                        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
                        languages2.add(INSTANCE.createLanguageObjects(uRL, className));
                        languageClassNames.add(className);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return languages2;
    }

    private final Language createLanguageObjects(URL url, String className) {
        Language language;
        try {
            Object obj = JLanguageTool.Companion.getClassBroker().forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.languagetool.language.Language");
            }
            language = (Language)obj;
        }
        catch (ClassNotFoundException e) {
            throw (Throwable)new RuntimeException("Class '" + className + "' specified in " + url + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Object for class '" + className + "' specified in " + url + " could not be created", e);
        }
        return language;
    }

    @Nullable
    public final Language getLanguageForName(@NotNull String languageName) {
        Intrinsics.checkParameterIsNotNull((Object)languageName, (String)"languageName");
        for (Language element : this.getStaticAndDynamicLanguages()) {
            if (!Intrinsics.areEqual((Object)languageName, (Object)element.getName())) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public final Language getLanguageForShortCode(@NotNull String langCode) {
        Intrinsics.checkParameterIsNotNull((Object)langCode, (String)"langCode");
        return this.getLanguageForShortCode(langCode, CollectionsKt.emptyList());
    }

    @NotNull
    public final Language getLanguageForShortCode(@NotNull String langCode, @NotNull List<String> noopLanguageCodes) {
        Intrinsics.checkParameterIsNotNull((Object)langCode, (String)"langCode");
        Intrinsics.checkParameterIsNotNull(noopLanguageCodes, (String)"noopLanguageCodes");
        Language language = this.getLanguageForShortCodeOrNull(langCode);
        if (language == null) {
            if (noopLanguageCodes.contains(langCode)) {
                language = NOOP_LANGUAGE;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<String> $this$apply = arrayList;
                boolean bl3 = false;
                for (Language realLanguage : INSTANCE.getStaticAndDynamicLanguages()) {
                    $this$apply.add(realLanguage.getShortCodeWithCountryAndVariant());
                }
                String codes = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                throw (Throwable)new IllegalArgumentException('\'' + langCode + "' is not a language code known to LanguageTool." + " Supported language codes are: " + codes + '.' + " The list of languages is read from META-INF/org/languagetool/language-module.properties  in the Java classpath.");
            }
        }
        return language;
    }

    public final boolean isLanguageSupported(@NotNull String langCode) {
        Intrinsics.checkParameterIsNotNull((Object)langCode, (String)"langCode");
        return this.getLanguageForShortCodeOrNull(langCode) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Language getLanguageForShortCodeOrNull(String langCode) {
        Language element;
        Language result = null;
        if (StringsKt.contains$default((CharSequence)langCode, (CharSequence)"-x-", (boolean)false, (int)2, null)) {
            Language element2;
            Iterator<Language> iterator2 = this.getStaticAndDynamicLanguages().iterator();
            do {
                if (!iterator2.hasNext()) return result;
            } while (!StringsKt.equals((String)(element2 = iterator2.next()).getShortCode(), (String)langCode, (boolean)true));
            return element2;
        }
        if (StringsKt.contains$default((CharSequence)langCode, (CharSequence)"-", (boolean)false, (int)2, null)) {
            Language element3;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)langCode, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] parts = stringArray;
            if (parts.length == 2) {
                Iterator<Language> iterator3 = this.getStaticAndDynamicLanguages().iterator();
                do {
                    if (!iterator3.hasNext()) return result;
                } while (!StringsKt.equals((String)parts[0], (String)(element3 = iterator3.next()).getShortCode(), (boolean)true) || element3.getCountries().length != 1 || !StringsKt.equals((String)parts[1], (String)element3.getCountries()[0], (boolean)true));
                return element3;
            }
            if (parts.length != 3) throw (Throwable)new IllegalArgumentException('\'' + langCode + "' isn't a valid language code");
            Iterator<Language> iterator4 = this.getStaticAndDynamicLanguages().iterator();
            do {
                if (!iterator4.hasNext()) return result;
            } while (!StringsKt.equals((String)parts[0], (String)(element3 = iterator4.next()).getShortCode(), (boolean)true) || element3.getCountries().length != 1 || !StringsKt.equals((String)parts[1], (String)element3.getCountries()[0], (boolean)true) || !StringsKt.equals((String)parts[2], (String)element3.getVariant(), (boolean)true));
            return element3;
        }
        Iterator<Language> iterator5 = this.getStaticAndDynamicLanguages().iterator();
        do {
            if (!iterator5.hasNext()) return result;
        } while (!StringsKt.equals((String)langCode, (String)(element = iterator5.next()).getShortCode(), (boolean)true));
        return element;
    }

    private Languages() {
    }

    public static final /* synthetic */ List access$getAllLanguages$p(Languages $this) {
        return $this.getAllLanguages();
    }
}

