/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.language.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleHandler;
import org.languagetool.tools.resource.ResourceBundleTools;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FalseFriendRuleLoader
extends DefaultHandler {
    private final String falseFriendHint;
    private final String falseFriendSugg;

    public FalseFriendRuleLoader(Language motherTongue) {
        ResourceBundle messages = ResourceBundleTools.INSTANCE.getMessageBundle(motherTongue);
        this.falseFriendHint = messages.getString("false_friend_hint");
        this.falseFriendSugg = messages.getString("false_friend_suggestion");
    }

    public FalseFriendRuleLoader(String falseFriendHint, String falseFriendSugg) {
        this.falseFriendHint = Objects.requireNonNull(falseFriendHint);
        this.falseFriendSugg = Objects.requireNonNull(falseFriendSugg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<AbstractPatternRule> getRules(File file, Language language, Language motherTongue) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            List<AbstractPatternRule> list = this.getRules(inputStream, language, motherTongue);
            return list;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Could not load false friend rules from " + file, e);
        }
    }

    public final List<AbstractPatternRule> getRules(InputStream stream, Language textLanguage, Language motherTongue) throws ParserConfigurationException, SAXException, IOException {
        FalseFriendRuleHandler handler = new FalseFriendRuleHandler(textLanguage, motherTongue, this.falseFriendHint);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxParser.parse(stream, (DefaultHandler)handler);
        List<AbstractPatternRule> rules = handler.getRules();
        MessageFormat msgFormat = new MessageFormat(this.falseFriendSugg);
        for (AbstractPatternRule rule : rules) {
            List<String> suggestions = handler.getSuggestionMap().get(rule.getId());
            if (suggestions == null) continue;
            String[] msg = new String[]{this.formatSuggestions(suggestions)};
            rule.setMessage(rule.getMessage() + " " + msgFormat.format(msg));
        }
        return rules;
    }

    private String formatSuggestions(List<String> l) {
        return l.stream().map(o -> "<suggestion>" + o + "</suggestion>").collect(Collectors.joining(", "));
    }
}

