/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.config.UserConfig;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.tools.Tools;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    protected MorfologikMultiSpeller speller1;
    protected MorfologikMultiSpeller speller2;
    protected MorfologikMultiSpeller speller3;
    protected Locale conversionLocale;
    private final SuggestionsOrderer suggestionsOrderer = null;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");
    private final UserConfig userConfig;

    public abstract String getFileName();

    @Override
    public abstract String getId();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig) throws IOException {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<? extends Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.userConfig = userConfig;
        super.setCategory(Categories.TYPOS.getCategory(messages, language));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        String binaryDict = null;
        if (JLanguageTool.getDataBroker().resourceExists(this.getFileName()) || Paths.get(this.getFileName(), new String[0]).toFile().exists()) {
            binaryDict = this.getFileName();
        }
        if (binaryDict == null) {
            throw new IllegalStateException("Speller binary dictionary not found");
        }
        this.initSpeller(binaryDict);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public boolean isMisspelled(String word) {
        return this.isMisspelled(this.speller1, word) || this.isProhibited(word);
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        int idx = -1;
        for (AnalyzedTokenReadings token : tokens) {
            int hiddenCharOffset;
            if (this.canBeIgnored(tokens, ++idx, token)) continue;
            int startPos = token.getStartPos();
            String word = token.getAnalyzedToken(0).getToken();
            int newRuleIdx = ruleMatches.size();
            if (this.tokenizingPattern() == null) {
                ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
            } else {
                int index = 0;
                Matcher m = this.tokenizingPattern().matcher(word);
                while (m.find()) {
                    String match = word.subSequence(index, m.start()).toString();
                    ruleMatches.addAll(this.getRuleMatches(match, startPos + index, sentence, ruleMatches, idx, tokens));
                    index = m.end();
                }
                if (index == 0) {
                    ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
                } else {
                    ruleMatches.addAll(this.getRuleMatches(word.subSequence(index, word.length()).toString(), startPos + index, sentence, ruleMatches, idx, tokens));
                }
            }
            if (ruleMatches.size() <= newRuleIdx || (hiddenCharOffset = token.getToken().length() - word.length()) <= 0) continue;
            for (int i = newRuleIdx; i < ruleMatches.size(); ++i) {
                RuleMatch ruleMatch = (RuleMatch)ruleMatches.get(i);
                if (token.getEndPos() < ruleMatch.getToPos()) continue;
                ruleMatch.setOffsetPosition(ruleMatch.getFromPos(), ruleMatch.getToPos() + hiddenCharOffset);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private void initSpeller(String binaryDict) throws IOException {
        String plainTextDict = null;
        String languageVariantPlainTextDict = null;
        if (this.getSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getSpellingFileName())) {
            plainTextDict = this.getSpellingFileName();
        }
        if (this.getLanguageVariantSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getLanguageVariantSpellingFileName())) {
            languageVariantPlainTextDict = this.getLanguageVariantSpellingFileName();
        }
        this.speller1 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 1);
        this.speller2 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 2);
        this.speller3 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 3);
        this.setConvertsCase(this.speller1.convertsCase());
    }

    private boolean canBeIgnored(AnalyzedTokenReadings[] tokens, int idx, AnalyzedTokenReadings token) throws IOException {
        return token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || this.isUrl(token.getToken()) || this.isEMail(token.getToken()) || this.ignoreTaggedWords && token.isTagged() && !this.isProhibited(token.getToken()) || this.ignoreToken(tokens, idx);
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (speller == null || !speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected int getFrequency(MorfologikMultiSpeller speller, String word) {
        return speller.getFrequency(word);
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        RuleMatch ruleMatch = null;
        if (this.isMisspelled(this.speller1, word) || this.isProhibited(word)) {
            String nextWord;
            String sugg;
            String sugg2b;
            String sugg2a;
            String sugg1b;
            String sugg1a;
            String prevWord;
            if (ruleMatchesSoFar.size() > 0 && ruleMatchesSoFar.get(ruleMatchesSoFar.size() - 1).getToPos() > startPos) {
                return ruleMatches;
            }
            if (idx > 0 && (prevWord = tokens[idx - 1].getToken()).length() > 0 && !prevWord.matches(".*\\d.*")) {
                int prevStartPos = tokens[idx - 1].getStartPos();
                sugg1a = prevWord.substring(0, prevWord.length() - 1);
                sugg1b = prevWord.substring(prevWord.length() - 1) + word;
                if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && this.getFrequency(this.speller1, sugg1a) + this.getFrequency(this.speller1, sugg1b) > this.getFrequency(this.speller1, prevWord)) {
                    ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg1a, sugg1b, prevStartPos);
                }
                sugg2a = prevWord + word.substring(0, 1);
                sugg2b = word.substring(1);
                if (sugg2a.length() > 1 && sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                    if (ruleMatch == null) {
                        if (this.getFrequency(this.speller1, sugg2a) + this.getFrequency(this.speller1, sugg2b) > this.getFrequency(this.speller1, prevWord)) {
                            ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg2a, sugg2b, prevStartPos);
                        }
                    } else {
                        ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                    }
                }
                sugg = prevWord + word;
                if (word.equals(word.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                    if (ruleMatch == null) {
                        if (this.getFrequency(this.speller1, sugg) >= this.getFrequency(this.speller1, prevWord)) {
                            ruleMatch = new RuleMatch(this, sentence, prevStartPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                            ruleMatch.setSuggestedReplacement(sugg);
                        }
                    } else {
                        ruleMatch.addSuggestedReplacement(sugg);
                    }
                }
            }
            if (ruleMatch != null) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
            if (idx < tokens.length - 1 && (nextWord = tokens[idx + 1].getToken()).length() > 0 && !nextWord.matches(".*\\d.*")) {
                int nextStartPos = tokens[idx + 1].getStartPos();
                sugg1a = word.substring(0, word.length() - 1);
                sugg1b = word.substring(word.length() - 1) + nextWord;
                if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && this.getFrequency(this.speller1, sugg1a) + this.getFrequency(this.speller1, sugg1b) > this.getFrequency(this.speller1, nextWord)) {
                    ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg1a, sugg1b, startPos);
                }
                sugg2a = word + nextWord.substring(0, 1);
                sugg2b = nextWord.substring(1);
                if (sugg2a.length() > 1 && sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                    if (ruleMatch == null) {
                        if (this.getFrequency(this.speller1, sugg2a) + this.getFrequency(this.speller1, sugg2b) > this.getFrequency(this.speller1, nextWord)) {
                            ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg2a, sugg2b, startPos);
                        }
                    } else {
                        ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                    }
                }
                sugg = word + nextWord;
                if (nextWord.equals(nextWord.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                    if (ruleMatch == null) {
                        if (this.getFrequency(this.speller1, sugg) >= this.getFrequency(this.speller1, nextWord)) {
                            ruleMatch = new RuleMatch(this, sentence, startPos, nextStartPos + nextWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                            ruleMatch.setSuggestedReplacement(sugg);
                        }
                    } else {
                        ruleMatch.addSuggestedReplacement(sugg);
                    }
                }
            }
            if (ruleMatch != null) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
            Language acceptingLanguage = this.acceptedInAlternativeLanguage(word);
            if (acceptingLanguage != null) {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), Tools.i18n(this.messages, "accepted_in_alt_language", word, this.messages.getString(acceptingLanguage.getShortCode())));
                ruleMatch.setType(RuleMatch.Type.Hint);
            } else {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            }
            boolean fullResults = false;
            if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatchesSoFar.size() <= this.userConfig.getMaxSpellingSuggestions()) {
                List<String> defaultSuggestions = this.speller1.getSuggestionsFromDefaultDicts(word);
                List<String> userSuggestions = this.speller1.getSuggestionsFromUserDicts(word);
                if (word.length() >= 3 && defaultSuggestions.isEmpty()) {
                    defaultSuggestions.addAll(this.speller2.getSuggestionsFromDefaultDicts(word));
                    userSuggestions.addAll(this.speller2.getSuggestionsFromUserDicts(word));
                    if (word.length() >= 5 && defaultSuggestions.isEmpty()) {
                        defaultSuggestions.addAll(this.speller3.getSuggestionsFromDefaultDicts(word));
                        userSuggestions.addAll(this.speller3.getSuggestionsFromUserDicts(word));
                    }
                }
                defaultSuggestions.addAll(0, this.getAdditionalTopSuggestions(defaultSuggestions, word));
                defaultSuggestions.addAll(this.getAdditionalSuggestions(defaultSuggestions, word));
                if (!defaultSuggestions.isEmpty() || !userSuggestions.isEmpty()) {
                    this.filterSuggestions(defaultSuggestions);
                    this.filterDupes(userSuggestions);
                    defaultSuggestions = this.orderSuggestions(defaultSuggestions, word);
                    MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, null, ruleMatch);
                }
            } else {
                ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
            }
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    @Nullable
    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }

    protected boolean isSurrogatePairCombination(String word) {
        if (word.length() > 1 && word.length() % 2 == 0 && word.codePointCount(0, word.length()) != word.length()) {
            boolean isSurrogatePairCombination = true;
            for (int i = 0; i < word.length() && isSurrogatePairCombination; isSurrogatePairCombination &= Character.isSurrogatePair(word.charAt(i), word.charAt(i + 1)), i += 2) {
            }
            return isSurrogatePairCombination;
        }
        return false;
    }

    @Override
    protected boolean ignoreWord(String word) throws IOException {
        return super.ignoreWord(word) || this.isSurrogatePairCombination(word);
    }
}

