/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tools.StringTools;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 42\u00020\u0001:\u000245B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J3\u0010\u0014\u001a\u0004\u0018\u00010\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0004J+\u0010!\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0017H\u0014J,\u0010)\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00172\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0004J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020/H\u0002J\u000e\u00100\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/languagetool/tagging/disambiguation/MultiWordChunker2;", "Lorg/languagetool/tagging/disambiguation/AbstractDisambiguator;", "filename", "", "allowFirstCapitalized", "", "(Ljava/lang/String;Z)V", "removeOtherReadings", "tagFormat", "tokenToPosTagMap", "", "", "Lorg/languagetool/tagging/disambiguation/MultiWordChunker2$MultiWordEntry;", "annotateToken", "prevAnot", "oldReading", "newReading", "disambiguate", "Lorg/languagetool/analysis/AnalyzedSentence;", "input", "findMultiwordEntry", "inputTokens", "", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "startingPosition", "", "multiwordItems", "", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;ILjava/util/List;)Lorg/languagetool/tagging/disambiguation/MultiWordChunker2$MultiWordEntry;", "formatPosTag", "posTag", "position", "multiwordLength", "isMatching", "multiWordEntry", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;ILorg/languagetool/tagging/disambiguation/MultiWordChunker2$MultiWordEntry;)Z", "loadWords", "stream", "Ljava/io/InputStream;", "matches", "matchText", "prepareNewReading", "tokens", "tok", "token", "tag", "setAndAnnotate", "Lorg/languagetool/analysis/AnalyzedToken;", "setRemoveOtherReadings", "", "setWrapTag", "wrapTag", "Companion", "MultiWordEntry", "languagetool-core"})
public class MultiWordChunker2
extends AbstractDisambiguator {
    private boolean removeOtherReadings;
    private String tagFormat;
    private Map<String, List<MultiWordEntry>> tokenToPosTagMap;
    private final String filename;
    private final boolean allowFirstCapitalized;
    private static final String WRAP_TAG = "<%s>";
    public static final Companion Companion = new Companion(null);

    public final void setRemoveOtherReadings(boolean removeOtherReadings) {
        this.removeOtherReadings = removeOtherReadings;
    }

    public final void setWrapTag(boolean wrapTag) {
        this.tagFormat = wrapTag ? WRAP_TAG : null;
    }

    @NotNull
    protected final String formatPosTag(@NotNull String posTag, int position, int multiwordLength) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)posTag, (String)"posTag");
                string = this.tagFormat;
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{posTag};
                boolean bl4 = false;
                String string3 = String.format(it, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = posTag;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AnalyzedSentence disambiguate(@NotNull AnalyzedSentence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        AnalyzedTokenReadings[] inputTokens = input.getTokens();
        int n = 1;
        int n2 = inputTokens.length;
        while (n < n2) {
            void i;
            block10: {
                List<MultiWordEntry> multiwordItems;
                block9: {
                    String firstToken = inputTokens[i].getToken();
                    multiwordItems = this.tokenToPosTagMap.get(firstToken);
                    if (multiwordItems != null) break block9;
                    if (this.allowFirstCapitalized && StringTools.isCapitalizedWord(firstToken)) {
                        multiwordItems = this.tokenToPosTagMap.get(StringTools.lowercaseFirstChar(firstToken));
                    }
                    if (multiwordItems == null) break block10;
                }
                if (this.findMultiwordEntry(inputTokens, (int)i, multiwordItems) == null) {
                } else {
                    MultiWordEntry multiwordEntry;
                    int multiwordPos = 0;
                    void inputTokenPos = i;
                    while (multiwordPos < multiwordEntry.getTokens().size()) {
                        AnalyzedTokenReadings currentToken = inputTokens[inputTokenPos];
                        if (currentToken.isWhitespace()) {
                            ++inputTokenPos;
                            continue;
                        }
                        String multiwordTag = this.formatPosTag(multiwordEntry.getTag(), multiwordPos, multiwordEntry.getTokens().size());
                        inputTokens[inputTokenPos] = this.prepareNewReading(multiwordEntry.getLemma(), currentToken.getToken(), currentToken, multiwordTag);
                        ++multiwordPos;
                        ++inputTokenPos;
                    }
                }
            }
            ++i;
        }
        return new AnalyzedSentence(inputTokens, null, 2, null);
    }

    private final MultiWordEntry findMultiwordEntry(AnalyzedTokenReadings[] inputTokens, int startingPosition, List<MultiWordEntry> multiwordItems) {
        Object v0;
        block1: {
            Iterable iterable = multiwordItems;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                MultiWordEntry it = (MultiWordEntry)t;
                boolean bl3 = false;
                if (!this.isMatching(inputTokens, startingPosition, it)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isMatching(AnalyzedTokenReadings[] inputTokens, int startingPosition, MultiWordEntry multiWordEntry) {
        int j = 1;
        int i = 1;
        while (j < multiWordEntry.getTokens().size() && startingPosition + i < inputTokens.length) {
            if (inputTokens[startingPosition + i].isWhitespace()) {
                ++i;
                continue;
            }
            if (!this.matches(multiWordEntry.getTokens().get(j), inputTokens[startingPosition + i])) {
                return false;
            }
            ++j;
            ++i;
        }
        return j == multiWordEntry.getTokens().size();
    }

    protected boolean matches(@Nullable String matchText, @NotNull AnalyzedTokenReadings inputTokens) {
        Intrinsics.checkParameterIsNotNull((Object)inputTokens, (String)"inputTokens");
        return Intrinsics.areEqual((Object)matchText, (Object)inputTokens.getToken());
    }

    @NotNull
    protected final AnalyzedTokenReadings prepareNewReading(@Nullable String tokens, @NotNull String tok, @NotNull AnalyzedTokenReadings token, @Nullable String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tok, (String)"tok");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return this.setAndAnnotate(token, new AnalyzedToken(tok, tag, tokens));
    }

    private final AnalyzedTokenReadings setAndAnnotate(AnalyzedTokenReadings oldReading, AnalyzedToken newReading) {
        AnalyzedTokenReadings analyzedTokenReadings = new AnalyzedTokenReadings(this.removeOtherReadings ? CollectionsKt.listOf((Object)newReading) : oldReading.getReadings(), oldReading.getStartPos());
        boolean bl = false;
        boolean bl2 = false;
        AnalyzedTokenReadings $this$apply = analyzedTokenReadings;
        boolean bl3 = false;
        $this$apply.setWhitespaceBefore(oldReading.isWhitespaceBefore());
        if (!this.removeOtherReadings) {
            $this$apply.addReading(newReading);
        }
        $this$apply.setHistoricalAnnotations(this.annotateToken(oldReading.getHistoricalAnnotations(), oldReading.toString(), $this$apply.toString()));
        $this$apply.setChunkTags(oldReading.getChunkTags());
        return analyzedTokenReadings;
    }

    private final String annotateToken(String prevAnot, String oldReading, String newReading) {
        return prevAnot + "\nMULTIWORD_CHUNKER: " + oldReading + " -> " + newReading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> loadWords(InputStream stream) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> $this$apply = arrayList;
        boolean bl3 = false;
        Closeable closeable = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl5 = false;
            Iterator iterator2 = reader.lines().iterator();
            while (iterator2.hasNext()) {
                String $this$trim$iv;
                String line = (String)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)line, (String)"line");
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl6 = false;
                    boolean bl7 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String line2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                CharSequence charSequence = line2;
                boolean bl8 = false;
                if (!(charSequence.length() > 0) || line2.charAt(0) == '#') continue;
                $this$apply.add(line2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    public MultiWordChunker2(@NotNull String filename, boolean allowFirstCapitalized) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        this.filename = filename;
        this.allowFirstCapitalized = allowFirstCapitalized;
        this.tagFormat = WRAP_TAG;
        this.tokenToPosTagMap = new HashMap();
        Closeable closeable = JLanguageTool.Companion.getDataBroker().getFromResourceDirAsStream(this.filename);
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl2 = false;
            for (String posToken : this.loadWords(stream)) {
                Object object;
                void $this$getOrPut$iv;
                Object[] tokens;
                String[] tokenAndTag;
                Collection $this$toTypedArray$iv22 = StringsKt.split$default((CharSequence)posToken, (String[])new String[]{"\t"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv222 = $this$toTypedArray$iv22;
                if (thisCollection$iv222.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                boolean $this$toTypedArray$iv22 = tokenAndTag.length == 2;
                $i$f$toTypedArray = false;
                boolean thisCollection$iv222 = false;
                if (!$this$toTypedArray$iv22) {
                    boolean bl3 = false;
                    String thisCollection$iv222 = "Invalid format in " + this.filename + ": '" + posToken + "', expected two tab-separated parts";
                    throw (Throwable)new IllegalArgumentException(thisCollection$iv222.toString());
                }
                Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)tokenAndTag[0], (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray2 = false;
                Object thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                $this$toTypedArray$iv = this.tokenToPosTagMap;
                String key$iv = tokens[0];
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    ArrayList answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(new MultiWordEntry(ArraysKt.toList((Object[])tokens), tokenAndTag[1]));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public /* synthetic */ MultiWordChunker2(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @JvmOverloads
    public MultiWordChunker2(@NotNull String filename) {
        this(filename, false, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/languagetool/tagging/disambiguation/MultiWordChunker2$MultiWordEntry;", "", "tokens", "", "", "tag", "(Ljava/util/List;Ljava/lang/String;)V", "lemma", "getLemma", "()Ljava/lang/String;", "getTag", "setTag", "(Ljava/lang/String;)V", "getTokens", "()Ljava/util/List;", "setTokens", "(Ljava/util/List;)V", "toString", "languagetool-core"})
    private static final class MultiWordEntry {
        @NotNull
        private List<String> tokens;
        @NotNull
        private String tag;

        @NotNull
        public final String getLemma() {
            String string = StringUtils.join((Iterable)this.tokens, (String)" ");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtils.join(tokens, \" \")");
            return string;
        }

        @NotNull
        public String toString() {
            return "MultiWordEntry [tokens=" + this.tokens + ", tag=" + this.tag + ']';
        }

        @NotNull
        public final List<String> getTokens() {
            return this.tokens;
        }

        public final void setTokens(@NotNull List<String> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.tokens = list;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.tag = string;
        }

        public MultiWordEntry(@NotNull List<String> tokens, @NotNull String tag) {
            Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.tokens = tokens;
            this.tag = tag;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/languagetool/tagging/disambiguation/MultiWordChunker2$Companion;", "", "()V", "WRAP_TAG", "", "languagetool-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

